/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;

public class ChunkInfo {
    private final String chunkName;
    private final long offset;
    private final long len;
    private ChecksumData checksumData;
    private final Map<String, String> metadata;

    public ChunkInfo(String chunkName, long offset, long len) {
        this.chunkName = chunkName;
        this.offset = offset;
        this.len = len;
        this.metadata = new TreeMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadata(String key, String value) throws IOException {
        Map<String, String> map = this.metadata;
        synchronized (map) {
            if (this.metadata.containsKey(key)) {
                throw new IOException("This key already exists. Key " + key);
            }
            this.metadata.put(key, value);
        }
    }

    public static ChunkInfo getFromProtoBuf(ContainerProtos.ChunkInfo info) throws IOException {
        Preconditions.checkNotNull((Object)info);
        ChunkInfo chunkInfo = new ChunkInfo(info.getChunkName(), info.getOffset(), info.getLen());
        for (int x = 0; x < info.getMetadataCount(); ++x) {
            chunkInfo.addMetadata(info.getMetadata(x).getKey(), info.getMetadata(x).getValue());
        }
        chunkInfo.setChecksumData(ChecksumData.getFromProtoBuf(info.getChecksumData()));
        return chunkInfo;
    }

    public ContainerProtos.ChunkInfo getProtoBufMessage() {
        ContainerProtos.ChunkInfo.Builder builder = ContainerProtos.ChunkInfo.newBuilder();
        builder.setChunkName(this.getChunkName());
        builder.setOffset(this.getOffset());
        builder.setLen(this.getLen());
        if (this.checksumData == null) {
            builder.setChecksumData(Checksum.getNoChecksumDataProto());
        } else {
            builder.setChecksumData(this.checksumData.getProtoBufMessage());
        }
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            ContainerProtos.KeyValue.Builder keyValBuilder = ContainerProtos.KeyValue.newBuilder();
            builder.addMetadata(keyValBuilder.setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return builder.build();
    }

    public String getChunkName() {
        return this.chunkName;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLen() {
        return this.len;
    }

    public ChecksumData getChecksumData() {
        return this.checksumData;
    }

    public void setChecksumData(ChecksumData cData) {
        this.checksumData = cData;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "ChunkInfo{chunkName='" + this.chunkName + ", offset=" + this.offset + ", len=" + this.len + '}';
    }
}

