/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class DatanodeIdYaml {
    private DatanodeIdYaml() {
    }

    public static void createDatanodeIdFile(DatanodeDetails datanodeDetails, File path) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        Yaml yaml = new Yaml(options);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");){
            yaml.dump((Object)DatanodeIdYaml.getDatanodeDetailsYaml(datanodeDetails), (Writer)writer);
        }
    }

    public static DatanodeDetails readDatanodeIdFile(File path) throws IOException {
        DatanodeDetails datanodeDetails;
        try (FileInputStream inputFileStream = new FileInputStream(path);){
            DatanodeDetailsYaml datanodeDetailsYaml;
            Yaml yaml = new Yaml();
            try {
                datanodeDetailsYaml = (DatanodeDetailsYaml)yaml.loadAs((InputStream)inputFileStream, DatanodeDetailsYaml.class);
            }
            catch (Exception e) {
                throw new IOException("Unable to parse yaml file.", e);
            }
            DatanodeDetails.Builder builder = DatanodeDetails.newBuilder();
            builder.setUuid(datanodeDetailsYaml.getUuid()).setIpAddress(datanodeDetailsYaml.getIpAddress()).setHostName(datanodeDetailsYaml.getHostName()).setCertSerialId(datanodeDetailsYaml.getCertSerialId());
            if (!MapUtils.isEmpty(datanodeDetailsYaml.getPortDetails())) {
                for (Map.Entry<String, Integer> portEntry : datanodeDetailsYaml.getPortDetails().entrySet()) {
                    builder.addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.valueOf((String)portEntry.getKey()), (Integer)portEntry.getValue()));
                }
            }
            datanodeDetails = builder.build();
        }
        return datanodeDetails;
    }

    private static DatanodeDetailsYaml getDatanodeDetailsYaml(DatanodeDetails datanodeDetails) {
        LinkedHashMap<String, Integer> portDetails = new LinkedHashMap<String, Integer>();
        if (!CollectionUtils.isEmpty((Collection)datanodeDetails.getPorts())) {
            for (DatanodeDetails.Port port : datanodeDetails.getPorts()) {
                portDetails.put(port.getName().toString(), port.getValue());
            }
        }
        return new DatanodeDetailsYaml(datanodeDetails.getUuid().toString(), datanodeDetails.getIpAddress(), datanodeDetails.getHostName(), datanodeDetails.getCertSerialId(), portDetails);
    }

    public static class DatanodeDetailsYaml {
        private String uuid;
        private String ipAddress;
        private String hostName;
        private String certSerialId;
        private Map<String, Integer> portDetails;

        public DatanodeDetailsYaml() {
        }

        private DatanodeDetailsYaml(String uuid, String ipAddress, String hostName, String certSerialId, Map<String, Integer> portDetails) {
            this.uuid = uuid;
            this.ipAddress = ipAddress;
            this.hostName = hostName;
            this.certSerialId = certSerialId;
            this.portDetails = portDetails;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getCertSerialId() {
            return this.certSerialId;
        }

        public Map<String, Integer> getPortDetails() {
            return this.portDetails;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public void setCertSerialId(String certSerialId) {
            this.certSerialId = certSerialId;
        }

        public void setPortDetails(Map<String, Integer> portDetails) {
            this.portDetails = portDetails;
        }
    }
}

