/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;

public final class ChunkLayOutVersion {
    private static final ChunkLayOutVersion[] CHUNK_LAYOUT_VERSION_INFOS = new ChunkLayOutVersion[]{new ChunkLayOutVersion(1, "Data without checksums.")};
    private int version;
    private String description;

    private ChunkLayOutVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    public static ChunkLayOutVersion getChunkLayOutVersion(int chunkVersion) {
        Preconditions.checkArgument((chunkVersion <= ChunkLayOutVersion.getLatestVersion().getVersion() ? 1 : 0) != 0);
        for (ChunkLayOutVersion chunkLayOutVersion : CHUNK_LAYOUT_VERSION_INFOS) {
            if (chunkLayOutVersion.getVersion() != chunkVersion) continue;
            return chunkLayOutVersion;
        }
        return null;
    }

    public static ChunkLayOutVersion[] getAllVersions() {
        return (ChunkLayOutVersion[])CHUNK_LAYOUT_VERSION_INFOS.clone();
    }

    public static ChunkLayOutVersion getLatestVersion() {
        return CHUNK_LAYOUT_VERSION_INFOS[CHUNK_LAYOUT_VERSION_INFOS.length - 1];
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }
}

