/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomContainerDeletionChoosingPolicy
implements ContainerDeletionChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RandomContainerDeletionChoosingPolicy.class);

    @Override
    public List<ContainerData> chooseContainerForBlockDeletion(int count, Map<Long, ContainerData> candidateContainers) throws StorageContainerException {
        Preconditions.checkNotNull(candidateContainers, (Object)"Internal assertion: candidate containers cannot be null");
        int currentCount = 0;
        LinkedList<ContainerData> result = new LinkedList<ContainerData>();
        ContainerData[] values = new ContainerData[candidateContainers.size()];
        for (ContainerData entry : (ContainerData[])DFSUtil.shuffle((Object[])candidateContainers.values().toArray(values))) {
            if (currentCount >= count) break;
            result.add(entry);
            ++currentCount;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Select container {} for block deletion, pending deletion blocks num: {}.", (Object)entry.getContainerID(), (Object)((KeyValueContainerData)entry).getNumPendingDeletionBlocks());
        }
        return result;
    }
}

