/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.interfaces;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueHandler;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;

public abstract class Handler {
    protected final Configuration conf;
    protected final ContainerSet containerSet;
    protected final VolumeSet volumeSet;
    protected String scmID;
    protected final ContainerMetrics metrics;
    protected String datanodeId;
    private Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender;

    protected Handler(Configuration config, String datanodeId, ContainerSet contSet, VolumeSet volumeSet, ContainerMetrics containerMetrics, Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender) {
        this.conf = config;
        this.containerSet = contSet;
        this.volumeSet = volumeSet;
        this.metrics = containerMetrics;
        this.datanodeId = datanodeId;
        this.icrSender = icrSender;
    }

    public static Handler getHandlerForContainerType(ContainerProtos.ContainerType containerType, Configuration config, String datanodeId, ContainerSet contSet, VolumeSet volumeSet, ContainerMetrics metrics, Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender) {
        switch (containerType) {
            case KeyValueContainer: {
                return new KeyValueHandler(config, datanodeId, contSet, volumeSet, metrics, icrSender);
            }
        }
        throw new IllegalArgumentException("Handler for ContainerType: " + containerType + "doesn't exist.");
    }

    protected String getDatanodeId() {
        return this.datanodeId;
    }

    protected void sendICR(Container container) throws StorageContainerException {
        StorageContainerDatanodeProtocolProtos.ContainerReplicaProto containerReport = container.getContainerReport();
        this.icrSender.accept(containerReport);
    }

    public abstract ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto var1, Container var2, DispatcherContext var3);

    public abstract Container importContainer(long var1, long var3, String var5, String var6, InputStream var7, TarContainerPacker var8) throws IOException;

    public abstract void exportContainer(Container var1, OutputStream var2, TarContainerPacker var3) throws IOException;

    public abstract void stop();

    public abstract void markContainerForClose(Container var1) throws IOException;

    public abstract void markContainerUnhealthy(Container var1) throws IOException;

    public abstract void quasiCloseContainer(Container var1) throws IOException;

    public abstract void closeContainer(Container var1) throws IOException;

    public abstract void deleteContainer(Container var1, boolean var2) throws IOException;

    public void setScmID(String scmId) {
        this.scmID = scmId;
    }
}

