/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import javax.annotation.PostConstruct;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.datanode")
public class DatanodeConfiguration {
    static final Logger LOG = LoggerFactory.getLogger(DatanodeConfiguration.class);
    @Config(key="replication.streams.limit", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.DATANODE}, description="The maximum number of replication commands a single datanode can execute simultaneously")
    private final int replicationMaxStreamsDefault = 10;
    private int replicationMaxStreams = 10;
    @Config(key="container.delete.threads.max", type=ConfigType.INT, defaultValue="2", tags={ConfigTag.DATANODE}, description="The maximum number of threads used to delete containers on a datanode")
    private final int containerDeleteThreadsDefault = 2;
    private int containerDeleteThreads = 2;

    @PostConstruct
    public void validate() {
        if (this.containerDeleteThreads < 1) {
            LOG.warn("hdds.datanode.container.delete.threads.max must be greater than zero and was set to {}. Defaulting to {}", (Object)this.containerDeleteThreads, (Object)2);
            this.containerDeleteThreads = 2;
        }
    }

    public void setReplicationMaxStreams(int replicationMaxStreams) {
        this.replicationMaxStreams = replicationMaxStreams;
    }

    public void setContainerDeleteThreads(int containerDeleteThreads) {
        this.containerDeleteThreads = containerDeleteThreads;
    }

    public int getReplicationMaxStreams() {
        return this.replicationMaxStreams;
    }

    public int getContainerDeleteThreads() {
        return this.containerDeleteThreads;
    }
}

