/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.InitDatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.RunningDatanodeState;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlockCommandStatus;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateContext {
    static final Logger LOG = LoggerFactory.getLogger(StateContext.class);
    private final Queue<SCMCommand> commandQueue;
    private final Map<Long, CommandStatus> cmdStatusMap;
    private final Lock lock;
    private final DatanodeStateMachine parent;
    private final AtomicLong stateExecutionCount;
    private final Configuration conf;
    private final Set<String> endpoints;
    private final Map<String, List<GeneratedMessage>> reports;
    private final Map<String, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> containerActions;
    private final Map<String, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>> pipelineActions;
    private DatanodeStateMachine.DatanodeStates state;
    private boolean shutdownOnError = false;
    private AtomicLong heartbeatFrequency = new AtomicLong(2000L);

    public StateContext(Configuration conf, DatanodeStateMachine.DatanodeStates state, DatanodeStateMachine parent) {
        this.conf = conf;
        this.state = state;
        this.parent = parent;
        this.commandQueue = new LinkedList<SCMCommand>();
        this.cmdStatusMap = new ConcurrentHashMap<Long, CommandStatus>();
        this.reports = new HashMap<String, List<GeneratedMessage>>();
        this.endpoints = new HashSet<String>();
        this.containerActions = new HashMap<String, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>>();
        this.pipelineActions = new HashMap<String, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>>();
        this.lock = new ReentrantLock();
        this.stateExecutionCount = new AtomicLong(0L);
    }

    public DatanodeStateMachine getParent() {
        return this.parent;
    }

    boolean isEntering() {
        return this.stateExecutionCount.get() == 0L;
    }

    boolean isExiting(DatanodeStateMachine.DatanodeStates newState) {
        boolean isExiting;
        boolean bl = isExiting = this.state != newState && this.stateExecutionCount.get() > 0L;
        if (isExiting) {
            this.stateExecutionCount.set(0L);
        }
        return isExiting;
    }

    public DatanodeStateMachine.DatanodeStates getState() {
        return this.state;
    }

    public void setState(DatanodeStateMachine.DatanodeStates state) {
        this.state = state;
    }

    private void setShutdownOnError(boolean value) {
        this.shutdownOnError = value;
    }

    public boolean getShutdownOnError() {
        return this.shutdownOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReport(GeneratedMessage report) {
        if (report != null) {
            Map<String, List<GeneratedMessage>> map = this.reports;
            synchronized (map) {
                for (String endpoint : this.endpoints) {
                    this.reports.get(endpoint).add(report);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBackReports(List<GeneratedMessage> reportsToPutBack, String endpoint) {
        Map<String, List<GeneratedMessage>> map = this.reports;
        synchronized (map) {
            if (this.reports.containsKey(endpoint)) {
                this.reports.get(endpoint).addAll(0, reportsToPutBack);
            }
        }
    }

    public List<GeneratedMessage> getAllAvailableReports(String endpoint) {
        return this.getReports(endpoint, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GeneratedMessage> getReports(String endpoint, int maxLimit) {
        LinkedList<GeneratedMessage> reportsToReturn = new LinkedList<GeneratedMessage>();
        Map<String, List<GeneratedMessage>> map = this.reports;
        synchronized (map) {
            List<GeneratedMessage> reportsForEndpoint = this.reports.get(endpoint);
            if (reportsForEndpoint != null) {
                List<GeneratedMessage> tempList = reportsForEndpoint.subList(0, Math.min(reportsForEndpoint.size(), maxLimit));
                reportsToReturn.addAll(tempList);
                tempList.clear();
            }
        }
        return reportsToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerAction(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Map<String, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            for (String endpoint : this.endpoints) {
                this.containerActions.get(endpoint).add(containerAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerActionIfAbsent(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Map<String, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            for (String endpoint : this.endpoints) {
                if (this.containerActions.get(endpoint).contains(containerAction)) continue;
                this.containerActions.get(endpoint).add(containerAction);
            }
        }
    }

    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getAllPendingContainerActions(String endpoint) {
        return this.getPendingContainerAction(endpoint, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getPendingContainerAction(String endpoint, int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction> containerActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction>();
        Map<String, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            if (!this.containerActions.isEmpty() && CollectionUtils.isNotEmpty((Collection)this.containerActions.get(endpoint))) {
                Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.containerActions.get(endpoint);
                int size = actions.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    StorageContainerDatanodeProtocolProtos.ContainerAction action = actions.poll();
                    Preconditions.checkNotNull((Object)action);
                    containerActionList.add(action);
                }
            }
            return containerActionList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPipelineActionIfAbsent(StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction) {
        Map<String, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>> map = this.pipelineActions;
        synchronized (map) {
            for (String endpoint : this.endpoints) {
                StorageContainerDatanodeProtocolProtos.PipelineAction pipelineActionIter;
                Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> actionsForEndpoint = this.pipelineActions.get(endpoint);
                Iterator iterator = actionsForEndpoint.iterator();
                while (!(!iterator.hasNext() || (pipelineActionIter = (StorageContainerDatanodeProtocolProtos.PipelineAction)iterator.next()).getAction() == pipelineAction.getAction() && pipelineActionIter.hasClosePipeline() && pipelineAction.hasClosePipeline() && pipelineActionIter.getClosePipeline().getPipelineID().equals((Object)pipelineAction.getClosePipeline().getPipelineID()))) {
                }
                actionsForEndpoint.add(pipelineAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.PipelineAction> getPendingPipelineAction(String endpoint, int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction> pipelineActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction>();
        Map<String, Queue<StorageContainerDatanodeProtocolProtos.PipelineAction>> map = this.pipelineActions;
        synchronized (map) {
            if (!this.pipelineActions.isEmpty() && CollectionUtils.isNotEmpty((Collection)this.pipelineActions.get(endpoint))) {
                Queue<StorageContainerDatanodeProtocolProtos.PipelineAction> actionsForEndpoint = this.pipelineActions.get(endpoint);
                int size = actionsForEndpoint.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    pipelineActionList.add(actionsForEndpoint.poll());
                }
            }
            return pipelineActionList;
        }
    }

    public DatanodeState<DatanodeStateMachine.DatanodeStates> getTask() {
        switch (this.state) {
            case INIT: {
                return new InitDatanodeState(this.conf, this.parent.getConnectionManager(), this);
            }
            case RUNNING: {
                return new RunningDatanodeState(this.conf, this.parent.getConnectionManager(), this);
            }
            case SHUTDOWN: {
                return null;
            }
        }
        throw new IllegalArgumentException("Not Implemented yet.");
    }

    public void execute(ExecutorService service, long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.stateExecutionCount.incrementAndGet();
        DatanodeState<DatanodeStateMachine.DatanodeStates> task = this.getTask();
        if (task != null) {
            if (this.isEntering()) {
                task.onEnter();
            }
            task.execute(service);
            DatanodeStateMachine.DatanodeStates newState = task.await(time, unit);
            if (this.state != newState) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Task {} executed, state transited from {} to {}", new Object[]{task.getClass().getSimpleName(), this.state, newState});
                }
                if (this.isExiting(newState)) {
                    task.onExit();
                }
                this.setState(newState);
            }
            if (this.state == DatanodeStateMachine.DatanodeStates.SHUTDOWN) {
                LOG.error("Critical error occurred in StateMachine, setting shutDownMachine");
                this.setShutdownOnError(true);
            }
        }
    }

    public SCMCommand getNextCommand() {
        this.lock.lock();
        try {
            SCMCommand sCMCommand = this.commandQueue.poll();
            return sCMCommand;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCommand(SCMCommand command) {
        this.lock.lock();
        try {
            this.commandQueue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        this.addCmdStatus(command);
    }

    public long getExecutionCount() {
        return this.stateExecutionCount.get();
    }

    public CommandStatus getCmdStatus(Long key) {
        return this.cmdStatusMap.get(key);
    }

    public void addCmdStatus(Long key, CommandStatus status) {
        this.cmdStatusMap.put(key, status);
    }

    public void addCmdStatus(SCMCommand cmd) {
        if (cmd.getType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) {
            this.addCmdStatus(cmd.getId(), DeleteBlockCommandStatus.DeleteBlockCommandStatusBuilder.newBuilder().setCmdId(cmd.getId()).setStatus(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING).setType(cmd.getType()).build());
        }
    }

    public Map<Long, CommandStatus> getCommandStatusMap() {
        return this.cmdStatusMap;
    }

    public boolean updateCommandStatus(Long cmdId, Consumer<CommandStatus> cmdStatusUpdater) {
        if (this.cmdStatusMap.containsKey(cmdId)) {
            cmdStatusUpdater.accept(this.cmdStatusMap.get(cmdId));
            return true;
        }
        return false;
    }

    public void configureHeartbeatFrequency() {
        this.heartbeatFrequency.set(HddsServerUtil.getScmHeartbeatInterval((Configuration)this.conf));
    }

    public long getHeartbeatFrequency() {
        return this.heartbeatFrequency.get();
    }

    public void addEndpoint(String endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
            this.containerActions.put(endpoint, new LinkedList());
            this.pipelineActions.put(endpoint, new LinkedList());
            this.reports.put(endpoint, new LinkedList());
        }
    }
}

