/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.helpers.DeletedContainerBlocksSummary;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CreatePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    static final Logger LOG = LoggerFactory.getLogger(HeartbeatEndpointTask.class);
    private final EndpointStateMachine rpcEndpoint;
    private final Configuration conf;
    private HddsProtos.DatanodeDetailsProto datanodeDetailsProto;
    private StateContext context;
    private int maxContainerActionsPerHB;
    private int maxPipelineActionsPerHB;

    public HeartbeatEndpointTask(EndpointStateMachine rpcEndpoint, Configuration conf, StateContext context) {
        this.rpcEndpoint = rpcEndpoint;
        this.conf = conf;
        this.context = context;
        this.maxContainerActionsPerHB = conf.getInt("hdds.container.action.max.limit", 20);
        this.maxPipelineActionsPerHB = conf.getInt("hdds.pipeline.action.max.limit", 20);
    }

    public HddsProtos.DatanodeDetailsProto getDatanodeDetailsProto() {
        return this.datanodeDetailsProto;
    }

    public void setDatanodeDetailsProto(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        this.datanodeDetailsProto = datanodeDetailsProto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        this.rpcEndpoint.lock();
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder = null;
        try {
            Preconditions.checkState((this.datanodeDetailsProto != null ? 1 : 0) != 0);
            requestBuilder = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(this.datanodeDetailsProto);
            this.addReports(requestBuilder);
            this.addContainerActions(requestBuilder);
            this.addPipelineActions(requestBuilder);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto request = requestBuilder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending heartbeat message :: {}", (Object)request.toString());
            }
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto reponse = this.rpcEndpoint.getEndPoint().sendHeartbeat(request);
            this.processResponse(reponse, this.datanodeDetailsProto);
            this.rpcEndpoint.setLastSuccessfulHeartbeat(ZonedDateTime.now());
            this.rpcEndpoint.zeroMissedCount();
        }
        catch (IOException ex) {
            if (requestBuilder != null) {
                this.putBackReports(requestBuilder);
            }
            this.rpcEndpoint.logIfNeeded(ex);
        }
        finally {
            this.rpcEndpoint.unlock();
        }
        return this.rpcEndpoint.getState();
    }

    private void putBackReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        LinkedList<GeneratedMessage> reports = new LinkedList<GeneratedMessage>();
        if (requestBuilder.hasContainerReport()) {
            reports.add(requestBuilder.getContainerReport());
        }
        if (requestBuilder.hasNodeReport()) {
            reports.add(requestBuilder.getNodeReport());
        }
        if (requestBuilder.getCommandStatusReportsCount() != 0) {
            reports.addAll(requestBuilder.getCommandStatusReportsList());
        }
        if (requestBuilder.getIncrementalContainerReportCount() != 0) {
            reports.addAll(requestBuilder.getIncrementalContainerReportList());
        }
        this.context.putBackReports(reports, this.rpcEndpoint.getAddressString());
    }

    private void addReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        for (GeneratedMessage report : this.context.getAllAvailableReports(this.rpcEndpoint.getAddressString())) {
            String reportName = report.getDescriptorForType().getFullName();
            for (Descriptors.FieldDescriptor descriptor : StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.getDescriptor().getFields()) {
                String heartbeatFieldName = descriptor.getMessageType().getFullName();
                if (!heartbeatFieldName.equals(reportName)) continue;
                if (descriptor.isRepeated()) {
                    requestBuilder.addRepeatedField(descriptor, report);
                    continue;
                }
                requestBuilder.setField(descriptor, report);
            }
        }
    }

    private void addContainerActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.context.getPendingContainerAction(this.rpcEndpoint.getAddressString(), this.maxContainerActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.ContainerActionsProto cap = StorageContainerDatanodeProtocolProtos.ContainerActionsProto.newBuilder().addAllContainerActions(actions).build();
            requestBuilder.setContainerActions(cap);
        }
    }

    private void addPipelineActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.PipelineAction> actions = this.context.getPendingPipelineAction(this.rpcEndpoint.getAddressString(), this.maxPipelineActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.PipelineActionsProto pap = StorageContainerDatanodeProtocolProtos.PipelineActionsProto.newBuilder().addAllPipelineActions(actions).build();
            requestBuilder.setPipelineActions(pap);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void processResponse(StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response, HddsProtos.DatanodeDetailsProto datanodeDetails) {
        Preconditions.checkState((boolean)response.getDatanodeUUID().equalsIgnoreCase(datanodeDetails.getUuid()), (Object)"Unexpected datanode ID in the response.");
        block9: for (StorageContainerDatanodeProtocolProtos.SCMCommandProto commandResponseProto : response.getCommandsList()) {
            switch (commandResponseProto.getCommandType()) {
                case reregisterCommand: {
                    if (this.rpcEndpoint.getState() == EndpointStateMachine.EndPointStates.HEARTBEAT) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Received SCM notification to register. Interrupt HEARTBEAT and transit to REGISTER state.");
                        }
                        this.rpcEndpoint.setState(EndpointStateMachine.EndPointStates.REGISTER);
                        continue block9;
                    }
                    if (!LOG.isDebugEnabled()) continue block9;
                    LOG.debug("Illegal state {} found, expecting {}.", (Object)this.rpcEndpoint.getState().name(), (Object)EndpointStateMachine.EndPointStates.HEARTBEAT);
                    continue block9;
                }
                case deleteBlocksCommand: {
                    DeleteBlocksCommand db = DeleteBlocksCommand.getFromProtobuf(commandResponseProto.getDeleteBlocksCommandProto());
                    if (db.blocksTobeDeleted().isEmpty()) continue block9;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(DeletedContainerBlocksSummary.getFrom(db.blocksTobeDeleted()).toString());
                    }
                    this.context.addCommand(db);
                    continue block9;
                }
                case closeContainerCommand: {
                    CloseContainerCommand closeContainer = CloseContainerCommand.getFromProtobuf(commandResponseProto.getCloseContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container close request for container {}", (Object)closeContainer.getContainerID());
                    }
                    this.context.addCommand(closeContainer);
                    continue block9;
                }
                case replicateContainerCommand: {
                    ReplicateContainerCommand replicateContainerCommand = ReplicateContainerCommand.getFromProtobuf(commandResponseProto.getReplicateContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container replicate request for container {}", (Object)replicateContainerCommand.getContainerID());
                    }
                    this.context.addCommand(replicateContainerCommand);
                    continue block9;
                }
                case deleteContainerCommand: {
                    DeleteContainerCommand deleteContainerCommand = DeleteContainerCommand.getFromProtobuf(commandResponseProto.getDeleteContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM delete container request for container {}", (Object)deleteContainerCommand.getContainerID());
                    }
                    this.context.addCommand(deleteContainerCommand);
                    continue block9;
                }
                case createPipelineCommand: {
                    CreatePipelineCommand createPipelineCommand = CreatePipelineCommand.getFromProtobuf(commandResponseProto.getCreatePipelineCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM create pipeline request {}", (Object)createPipelineCommand.getPipelineID());
                    }
                    this.context.addCommand(createPipelineCommand);
                    continue block9;
                }
                case closePipelineCommand: {
                    ClosePipelineCommand closePipelineCommand = ClosePipelineCommand.getFromProtobuf(commandResponseProto.getClosePipelineCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM close pipeline request {}", (Object)closePipelineCommand.getPipelineID());
                    }
                    this.context.addCommand(closePipelineCommand);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown response : " + commandResponseProto.getCommandType().name());
        }
    }

    public static class Builder {
        private EndpointStateMachine endPointStateMachine;
        private Configuration conf;
        private DatanodeDetails datanodeDetails;
        private StateContext context;

        public Builder setEndpointStateMachine(EndpointStateMachine rpcEndPoint) {
            this.endPointStateMachine = rpcEndPoint;
            return this;
        }

        public Builder setConfig(Configuration config) {
            this.conf = config;
            return this;
        }

        public Builder setDatanodeDetails(DatanodeDetails dnDetails) {
            this.datanodeDetails = dnDetails;
            return this;
        }

        public Builder setContext(StateContext stateContext) {
            this.context = stateContext;
            return this;
        }

        public HeartbeatEndpointTask build() {
            if (this.endPointStateMachine == null) {
                LOG.error("No endpoint specified.");
                throw new IllegalArgumentException("A valid endpoint state machine is needed to construct HeartbeatEndpointTask task");
            }
            if (this.conf == null) {
                LOG.error("No config specified.");
                throw new IllegalArgumentException("A valid configration is needed to construct HeartbeatEndpointTask task");
            }
            if (this.datanodeDetails == null) {
                LOG.error("No datanode specified.");
                throw new IllegalArgumentException("A vaild Node ID is needed to construct HeartbeatEndpointTask task");
            }
            HeartbeatEndpointTask task = new HeartbeatEndpointTask(this.endPointStateMachine, this.conf, this.context);
            task.setDatanodeDetailsProto(this.datanodeDetails.getProtoBufMessage());
            return task;
        }
    }
}

