/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server;

import com.google.common.base.Preconditions;
import io.opentracing.Scope;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.GrpcServerInterceptor;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.transport.server.GrpcXceiverService;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.apache.ratis.thirdparty.io.grpc.Server;
import org.apache.ratis.thirdparty.io.grpc.ServerBuilder;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ServerInterceptors;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyServerBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverServerGrpc
implements XceiverServerSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverServerGrpc.class);
    private static final String COMPONENT = "dn";
    private int port;
    private UUID id;
    private Server server;
    private final ContainerDispatcher storageContainer;
    private boolean isStarted;
    private DatanodeDetails datanodeDetails;

    public XceiverServerGrpc(DatanodeDetails datanodeDetails, Configuration conf, ContainerDispatcher dispatcher, CertificateClient caClient, BindableService ... additionalServices) {
        Preconditions.checkNotNull((Object)conf);
        this.id = datanodeDetails.getUuid();
        this.datanodeDetails = datanodeDetails;
        this.port = conf.getInt("dfs.container.ipc", 9859);
        if (conf.getBoolean("dfs.container.ipc.random.port", false)) {
            this.port = 0;
        }
        NettyServerBuilder nettyServerBuilder = ((NettyServerBuilder)ServerBuilder.forPort((int)this.port)).maxInboundMessageSize(0x2000000);
        GrpcServerInterceptor tracingInterceptor = new GrpcServerInterceptor();
        nettyServerBuilder.addService(ServerInterceptors.intercept((BindableService)new GrpcXceiverService(dispatcher), (ServerInterceptor[])new ServerInterceptor[]{tracingInterceptor}));
        for (BindableService service : additionalServices) {
            nettyServerBuilder.addService(service);
        }
        SecurityConfig secConf = new SecurityConfig(conf);
        if (secConf.isGrpcTlsEnabled()) {
            try {
                SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((PrivateKey)caClient.getPrivateKey(), (X509Certificate[])new X509Certificate[]{caClient.getCertificate()});
                SslContextBuilder sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)secConf.getGrpcSslProvider());
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                LOG.error("Unable to setup TLS for secure datanode GRPC endpoint.", (Throwable)ex);
            }
        }
        this.server = nettyServerBuilder.build();
        this.storageContainer = dispatcher;
    }

    @Override
    public int getIPCPort() {
        return this.port;
    }

    @Override
    public HddsProtos.ReplicationType getServerType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }

    @Override
    public void start() throws IOException {
        if (!this.isStarted) {
            this.server.start();
            int realPort = this.server.getPort();
            if (this.port == 0) {
                LOG.info("{} {} is started using port {}", new Object[]{this.getClass().getSimpleName(), this.id, realPort});
                this.port = realPort;
            }
            this.datanodeDetails.setPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)realPort));
            this.isStarted = true;
        }
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            this.server.shutdown();
            try {
                this.server.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.error("failed to shutdown XceiverServerGrpc", (Throwable)e);
            }
            this.isStarted = false;
        }
    }

    @Override
    public void submitRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID) throws IOException {
        try (Scope scope = TracingUtil.importAndCreateScope((String)("XceiverServerGrpc." + request.getCmdType().name()), (String)request.getTraceID());){
            ContainerProtos.ContainerCommandResponseProto response = this.storageContainer.dispatch(request, null);
            if (response.getResult() != ContainerProtos.Result.SUCCESS) {
                throw new StorageContainerException(response.getMessage(), response.getResult());
            }
        }
    }

    @Override
    public boolean isExist(HddsProtos.PipelineID pipelineId) {
        return PipelineID.valueOf((UUID)this.id).getProtobuf().equals((Object)pipelineId);
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.PipelineReport> getPipelineReport() {
        return Collections.singletonList(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(PipelineID.valueOf((UUID)this.id).getProtobuf()).build());
    }
}

