/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.apache.hadoop.hdds.utils.MetadataStoreBuilder;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerCache
extends LRUMap {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCache.class);
    private final Lock lock = new ReentrantLock();
    private static ContainerCache cache;
    private static final float LOAD_FACTOR = 0.75f;

    private ContainerCache(int maxSize, float loadFactor, boolean scanUntilRemovable) {
        super(maxSize, loadFactor, scanUntilRemovable);
    }

    public static synchronized ContainerCache getInstance(Configuration conf) {
        if (cache == null) {
            int cacheSize = conf.getInt("ozone.container.cache.size", 1024);
            cache = new ContainerCache(cacheSize, 0.75f, true);
        }
        return cache;
    }

    public void shutdownCache() {
        this.lock.lock();
        try {
            MapIterator iterator = cache.mapIterator();
            while (iterator.hasNext()) {
                iterator.next();
                ReferenceCountedDB db = (ReferenceCountedDB)iterator.getValue();
                Preconditions.checkArgument((boolean)db.cleanup(), (String)"refCount:", (long)db.getReferenceCount());
            }
            cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
        ReferenceCountedDB db = (ReferenceCountedDB)entry.getValue();
        this.lock.lock();
        try {
            boolean bl = db.cleanup();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReferenceCountedDB getDB(long containerID, String containerDBType, String containerDBPath, Configuration conf) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        this.lock.lock();
        try {
            ReferenceCountedDB db = (ReferenceCountedDB)this.get(containerDBPath);
            if (db == null) {
                MetadataStore metadataStore = MetadataStoreBuilder.newBuilder().setDbFile(new File(containerDBPath)).setCreateIfMissing(false).setConf(conf).setDBType(containerDBType).build();
                db = new ReferenceCountedDB(metadataStore, containerDBPath);
                this.put(containerDBPath, db);
            }
            db.incrementReference();
            ReferenceCountedDB referenceCountedDB = db;
            return referenceCountedDB;
        }
        catch (Exception e) {
            LOG.error("Error opening DB. Container:{} ContainerPath:{}", new Object[]{containerID, containerDBPath, e});
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDB(String containerDBPath) {
        this.lock.lock();
        try {
            ReferenceCountedDB db = (ReferenceCountedDB)this.get(containerDBPath);
            if (db != null) {
                Preconditions.checkArgument((boolean)db.cleanup(), (String)"refCount:", (long)db.getReferenceCount());
            }
            this.remove(containerDBPath);
        }
        finally {
            this.lock.unlock();
        }
    }
}

