/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceCountedDB
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceCountedDB.class);
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private final MetadataStore store;
    private final String containerDBPath;

    public ReferenceCountedDB(MetadataStore store, String containerDBPath) {
        this.store = store;
        this.containerDBPath = containerDBPath;
    }

    public long getReferenceCount() {
        return this.referenceCount.get();
    }

    public void incrementReference() {
        this.referenceCount.incrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace("IncRef {} to refCnt {}, stackTrace: {}", new Object[]{this.containerDBPath, this.referenceCount.get(), ExceptionUtils.getStackTrace((Throwable)new Throwable())});
        }
    }

    public void decrementReference() {
        int refCount = this.referenceCount.decrementAndGet();
        Preconditions.checkArgument((refCount >= 0 ? 1 : 0) != 0, (String)"refCount:", (int)refCount);
        if (LOG.isTraceEnabled()) {
            LOG.trace("DecRef {} to refCnt {}, stackTrace: {}", new Object[]{this.containerDBPath, this.referenceCount.get(), ExceptionUtils.getStackTrace((Throwable)new Throwable())});
        }
    }

    public boolean cleanup() {
        if (this.referenceCount.get() == 0 && this.store != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Close {} refCnt {}", (Object)this.containerDBPath, (Object)this.referenceCount.get());
            }
            try {
                this.store.close();
                return true;
            }
            catch (Exception e) {
                LOG.error("Error closing DB. Container: " + this.containerDBPath, (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public MetadataStore getStore() {
        return this.store;
    }

    @Override
    public void close() {
        this.decrementReference();
    }
}

