/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.util.concurrent.atomic.AtomicLong;

public class VolumeIOStats {
    private final AtomicLong readBytes = new AtomicLong(0L);
    private final AtomicLong readOpCount = new AtomicLong(0L);
    private final AtomicLong writeBytes = new AtomicLong(0L);
    private final AtomicLong writeOpCount = new AtomicLong(0L);
    private final AtomicLong readTime = new AtomicLong(0L);
    private final AtomicLong writeTime = new AtomicLong(0L);

    public void incReadBytes(long bytesRead) {
        this.readBytes.addAndGet(bytesRead);
    }

    public void incReadOpCount() {
        this.readOpCount.incrementAndGet();
    }

    public void incWriteBytes(long bytesWritten) {
        this.writeBytes.addAndGet(bytesWritten);
    }

    public void incWriteOpCount() {
        this.writeOpCount.incrementAndGet();
    }

    public void incReadTime(long time) {
        this.readTime.addAndGet(time);
    }

    public void incWriteTime(long time) {
        this.writeTime.addAndGet(time);
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    public long getReadOpCount() {
        return this.readOpCount.get();
    }

    public long getWriteOpCount() {
        return this.writeOpCount.get();
    }

    public long getReadTime() {
        return this.readTime.get();
    }

    public long getWriteTime() {
        return this.writeTime.get();
    }
}

