/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.protocolPB.ContainerCommandResponseBuilders;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.impl.BlockManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerFactory;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueHandler
extends Handler {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueHandler.class);
    private final ContainerProtos.ContainerType containerType = ContainerProtos.ContainerType.KeyValueContainer;
    private final BlockManager blockManager;
    private final ChunkManager chunkManager;
    private final VolumeChoosingPolicy volumeChoosingPolicy;
    private final long maxContainerSize;
    private final Function<ByteBuffer, ByteString> byteBufferToByteString;
    private final AutoCloseableLock containerCreationLock;
    private final boolean doSyncWrite;

    public KeyValueHandler(Configuration config, String datanodeId, ContainerSet contSet, VolumeSet volSet, ContainerMetrics metrics, Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender) {
        super(config, datanodeId, contSet, volSet, metrics, icrSender);
        this.blockManager = new BlockManagerImpl(config);
        this.doSyncWrite = this.conf.getBoolean("dfs.container.chunk.write.sync", false);
        this.chunkManager = ChunkManagerFactory.getChunkManager(config, this.doSyncWrite);
        this.volumeChoosingPolicy = (VolumeChoosingPolicy)ReflectionUtils.newInstance((Class)this.conf.getClass("hdds.datanode.volume.choosing.policy", RoundRobinVolumeChoosingPolicy.class, VolumeChoosingPolicy.class), (Configuration)this.conf);
        this.maxContainerSize = (long)config.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.containerCreationLock = new AutoCloseableLock((Lock)new ReentrantLock(true));
        this.byteBufferToByteString = ByteStringConversion.createByteBufferConversion((Configuration)this.conf);
    }

    @VisibleForTesting
    public VolumeChoosingPolicy getVolumeChoosingPolicyForTesting() {
        return this.volumeChoosingPolicy;
    }

    @Override
    public void stop() {
    }

    @Override
    public ContainerProtos.ContainerCommandResponseProto handle(ContainerProtos.ContainerCommandRequestProto request, Container container, DispatcherContext dispatcherContext) {
        ContainerProtos.Type cmdType = request.getCmdType();
        KeyValueContainer kvContainer = (KeyValueContainer)container;
        switch (cmdType) {
            case CreateContainer: {
                return this.handleCreateContainer(request, kvContainer);
            }
            case ReadContainer: {
                return this.handleReadContainer(request, kvContainer);
            }
            case UpdateContainer: {
                return this.handleUpdateContainer(request, kvContainer);
            }
            case DeleteContainer: {
                return this.handleDeleteContainer(request, kvContainer);
            }
            case ListContainer: {
                return this.handleUnsupportedOp(request);
            }
            case CloseContainer: {
                return this.handleCloseContainer(request, kvContainer);
            }
            case PutBlock: {
                return this.handlePutBlock(request, kvContainer, dispatcherContext);
            }
            case GetBlock: {
                return this.handleGetBlock(request, kvContainer);
            }
            case DeleteBlock: {
                return this.handleDeleteBlock(request, kvContainer);
            }
            case ListBlock: {
                return this.handleUnsupportedOp(request);
            }
            case ReadChunk: {
                return this.handleReadChunk(request, kvContainer, dispatcherContext);
            }
            case DeleteChunk: {
                return this.handleDeleteChunk(request, kvContainer);
            }
            case WriteChunk: {
                return this.handleWriteChunk(request, kvContainer, dispatcherContext);
            }
            case ListChunk: {
                return this.handleUnsupportedOp(request);
            }
            case CompactChunk: {
                return this.handleUnsupportedOp(request);
            }
            case PutSmallFile: {
                return this.handlePutSmallFile(request, kvContainer, dispatcherContext);
            }
            case GetSmallFile: {
                return this.handleGetSmallFile(request, kvContainer);
            }
            case GetCommittedBlockLength: {
                return this.handleGetCommittedBlockLength(request, kvContainer);
            }
        }
        return null;
    }

    @VisibleForTesting
    public ChunkManager getChunkManager() {
        return this.chunkManager;
    }

    @VisibleForTesting
    public BlockManager getBlockManager() {
        return this.blockManager;
    }

    ContainerProtos.ContainerCommandResponseProto handleCreateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCreateContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Create Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        Preconditions.checkArgument((kvContainer == null ? 1 : 0) != 0);
        long containerID = request.getContainerID();
        KeyValueContainerData newContainerData = new KeyValueContainerData(containerID, this.maxContainerSize, request.getPipelineID(), this.getDatanodeId());
        KeyValueContainer newContainer = new KeyValueContainer(newContainerData, this.conf);
        boolean created = false;
        try (AutoCloseableLock l = this.containerCreationLock.acquire();){
            if (this.containerSet.getContainer(containerID) == null) {
                newContainer.create(this.volumeSet, this.volumeChoosingPolicy, this.scmID);
                created = this.containerSet.addContainer(newContainer);
            } else {
                LOG.debug("Container already exists. container Id {}", (Object)containerID);
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        if (created) {
            try {
                this.sendICR(newContainer);
            }
            catch (StorageContainerException ex) {
                return ContainerUtils.logAndReturnError(LOG, ex, request);
            }
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateContainerPathFields(KeyValueContainer container, long maxSize) throws IOException {
        this.volumeSet.readLock();
        try {
            HddsVolume containerVolume = this.volumeChoosingPolicy.chooseVolume(this.volumeSet.getVolumesList(), maxSize);
            String hddsVolumeDir = containerVolume.getHddsRootDir().toString();
            container.populatePathFields(this.scmID, containerVolume, hddsVolumeDir);
        }
        finally {
            this.volumeSet.readUnlock();
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleReadContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasReadContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerIsHealthy(kvContainer);
        }
        catch (StorageContainerException sce) {
            return ContainerUtils.logAndReturnError(LOG, sce, request);
        }
        KeyValueContainerData containerData = kvContainer.getContainerData();
        return ContainerCommandResponseBuilders.getReadContainerResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.ContainerDataProto)containerData.getProtoBufMessage());
    }

    ContainerProtos.ContainerCommandResponseProto handleUpdateContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasUpdateContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        boolean forceUpdate = request.getUpdateContainer().getForceUpdate();
        List keyValueList = request.getUpdateContainer().getMetadataList();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (ContainerProtos.KeyValue keyValue : keyValueList) {
            metadata.put(keyValue.getKey(), keyValue.getValue());
        }
        try {
            if (!metadata.isEmpty()) {
                kvContainer.update(metadata, forceUpdate);
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Delete container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        boolean forceDelete = request.getDeleteContainer().getForceDelete();
        try {
            this.deleteInternal(kvContainer, forceDelete);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleCloseContainer(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasCloseContainer()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Update Container request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.markContainerForClose(kvContainer);
            this.closeContainer(kvContainer);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Close Container failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.BlockData blockDataProto;
        if (!request.hasPutBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Put Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)request.getPutBlock().getBlockData());
            Preconditions.checkNotNull((Object)blockData);
            long bcsId = dispatcherContext == null ? 0L : dispatcherContext.getLogIndex();
            blockData.setBlockCommitSequenceId(bcsId);
            this.blockManager.putBlock(kvContainer, blockData);
            blockDataProto = blockData.getProtoBufMessage();
            long numBytes = blockDataProto.getSerializedSize();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Put Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.putBlockResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        ContainerProtos.BlockData responseData;
        if (!request.hasGetBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerIsHealthy(kvContainer);
        }
        catch (StorageContainerException sce) {
            return ContainerUtils.logAndReturnError(LOG, sce, request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetBlock().getBlockID());
            responseData = this.blockManager.getBlock(kvContainer, blockID).getProtoBufMessage();
            long numBytes = responseData.getSerializedSize();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetBlock, numBytes);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Get Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockDataResponse((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)responseData);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetCommittedBlockLength(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        long blockLength;
        if (!request.hasGetCommittedBlockLength()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerIsHealthy(kvContainer);
        }
        catch (StorageContainerException sce) {
            return ContainerUtils.logAndReturnError(LOG, sce, request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getGetCommittedBlockLength().getBlockID());
            blockLength = this.blockManager.getCommittedBlockLength(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("GetCommittedBlockLength failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockLengthResponse((ContainerProtos.ContainerCommandRequestProto)request, (long)blockLength);
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteBlock(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteBlock()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Delete Key request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getDeleteBlock().getBlockID());
            this.blockManager.deleteBlock(kvContainer, blockID);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Delete Key failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getBlockResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleReadChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ChunkBuffer data;
        if (!request.hasReadChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Read Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerIsHealthy(kvContainer);
        }
        catch (StorageContainerException sce) {
            return ContainerUtils.logAndReturnError(LOG, sce, request);
        }
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getReadChunk().getBlockID());
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)request.getReadChunk().getChunkData());
            Preconditions.checkNotNull((Object)chunkInfo);
            if (dispatcherContext == null) {
                dispatcherContext = new DispatcherContext.Builder().build();
            }
            data = this.chunkManager.readChunk(kvContainer, blockID, chunkInfo, dispatcherContext);
            this.metrics.incContainerBytesStats(ContainerProtos.Type.ReadChunk, chunkInfo.getLen());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        Preconditions.checkNotNull((Object)data, (Object)"Chunk data is null");
        ByteString byteString = data.toByteString(this.byteBufferToByteString);
        return ContainerCommandResponseBuilders.getReadChunkResponse((ContainerProtos.ContainerCommandRequestProto)request, (ByteString)byteString);
    }

    @VisibleForTesting
    void checkContainerIsHealthy(KeyValueContainer kvContainer) throws StorageContainerException {
        kvContainer.readLock();
        try {
            if (kvContainer.getContainerData().getState() == ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                throw new StorageContainerException("The container replica is unhealthy.", ContainerProtos.Result.CONTAINER_UNHEALTHY);
            }
        }
        finally {
            kvContainer.readUnlock();
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleDeleteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasDeleteChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Delete Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerIsHealthy(kvContainer);
        }
        catch (StorageContainerException sce) {
            return ContainerUtils.logAndReturnError(LOG, sce, request);
        }
        try {
            this.checkContainerOpen(kvContainer);
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)request.getDeleteChunk().getBlockID());
            ContainerProtos.ChunkInfo chunkInfoProto = request.getDeleteChunk().getChunkData();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            this.chunkManager.deleteChunk(kvContainer, blockID, chunkInfo);
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Delete Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handleWriteChunk(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        if (!request.hasWriteChunk()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Write Chunk request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            DispatcherContext.WriteChunkStage stage;
            this.checkContainerOpen(kvContainer);
            ContainerProtos.WriteChunkRequestProto writeChunk = request.getWriteChunk();
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)writeChunk.getBlockID());
            ContainerProtos.ChunkInfo chunkInfoProto = writeChunk.getChunkData();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ChunkBuffer data = null;
            if (dispatcherContext == null) {
                dispatcherContext = new DispatcherContext.Builder().build();
            }
            if ((stage = dispatcherContext.getStage()) == DispatcherContext.WriteChunkStage.WRITE_DATA || stage == DispatcherContext.WriteChunkStage.COMBINED) {
                data = ChunkBuffer.wrap((List)writeChunk.getData().asReadOnlyByteBufferList());
            }
            this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
            if (stage == DispatcherContext.WriteChunkStage.WRITE_DATA || stage == DispatcherContext.WriteChunkStage.COMBINED) {
                this.metrics.incContainerBytesStats(ContainerProtos.Type.WriteChunk, writeChunk.getChunkData().getLen());
            }
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.IO_EXCEPTION), request);
        }
        return ContainerCommandResponseBuilders.getSuccessResponse((ContainerProtos.ContainerCommandRequestProto)request);
    }

    ContainerProtos.ContainerCommandResponseProto handlePutSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer, DispatcherContext dispatcherContext) {
        ContainerProtos.BlockData blockDataProto;
        if (!request.hasPutSmallFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Put Small File request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        ContainerProtos.PutSmallFileRequestProto putSmallFileReq = request.getPutSmallFile();
        try {
            this.checkContainerOpen(kvContainer);
            BlockData blockData = BlockData.getFromProtoBuf((ContainerProtos.BlockData)putSmallFileReq.getBlock().getBlockData());
            Preconditions.checkNotNull((Object)blockData);
            ContainerProtos.ChunkInfo chunkInfoProto = putSmallFileReq.getChunkInfo();
            ChunkInfo chunkInfo = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfoProto);
            Preconditions.checkNotNull((Object)chunkInfo);
            ChunkBuffer data = ChunkBuffer.wrap((List)putSmallFileReq.getData().asReadOnlyByteBufferList());
            if (dispatcherContext == null) {
                dispatcherContext = new DispatcherContext.Builder().build();
            }
            BlockID blockID = blockData.getBlockID();
            this.chunkManager.writeChunk((Container)kvContainer, blockID, chunkInfo, data, dispatcherContext);
            LinkedList<ContainerProtos.ChunkInfo> chunks = new LinkedList<ContainerProtos.ChunkInfo>();
            chunks.add(chunkInfoProto);
            blockData.setChunks(chunks);
            blockData.setBlockCommitSequenceId(dispatcherContext.getLogIndex());
            this.blockManager.putBlock(kvContainer, blockData);
            blockDataProto = blockData.getProtoBufMessage();
            this.metrics.incContainerBytesStats(ContainerProtos.Type.PutSmallFile, chunkInfo.getLen());
        }
        catch (StorageContainerException ex) {
            return ContainerUtils.logAndReturnError(LOG, ex, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Read Chunk failed", (Throwable)ex, ContainerProtos.Result.PUT_SMALL_FILE_ERROR), request);
        }
        return ContainerCommandResponseBuilders.getPutFileResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ContainerProtos.BlockData)blockDataProto);
    }

    ContainerProtos.ContainerCommandResponseProto handleGetSmallFile(ContainerProtos.ContainerCommandRequestProto request, KeyValueContainer kvContainer) {
        if (!request.hasGetSmallFile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Malformed Get Small File request. trace ID: {}", (Object)request.getTraceID());
            }
            return ContainerCommandResponseBuilders.malformedRequest((ContainerProtos.ContainerCommandRequestProto)request);
        }
        try {
            this.checkContainerIsHealthy(kvContainer);
        }
        catch (StorageContainerException sce) {
            return ContainerUtils.logAndReturnError(LOG, sce, request);
        }
        ContainerProtos.GetSmallFileRequestProto getSmallFileReq = request.getGetSmallFile();
        try {
            BlockID blockID = BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)getSmallFileReq.getBlock().getBlockID());
            BlockData responseData = this.blockManager.getBlock(kvContainer, blockID);
            ContainerProtos.ChunkInfo chunkInfo = null;
            ByteString dataBuf = ByteString.EMPTY;
            DispatcherContext dispatcherContext = new DispatcherContext.Builder().build();
            for (ContainerProtos.ChunkInfo chunk : responseData.getChunks()) {
                ChunkBuffer data = this.chunkManager.readChunk(kvContainer, blockID, ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk), dispatcherContext);
                ByteString current = data.toByteString(this.byteBufferToByteString);
                dataBuf = dataBuf.concat(current);
                chunkInfo = chunk;
            }
            this.metrics.incContainerBytesStats(ContainerProtos.Type.GetSmallFile, dataBuf.size());
            return ContainerCommandResponseBuilders.getGetSmallFileResponseSuccess((ContainerProtos.ContainerCommandRequestProto)request, (ByteString)dataBuf, chunkInfo);
        }
        catch (StorageContainerException e) {
            return ContainerUtils.logAndReturnError(LOG, e, request);
        }
        catch (IOException ex) {
            return ContainerUtils.logAndReturnError(LOG, new StorageContainerException("Write Chunk failed", (Throwable)ex, ContainerProtos.Result.GET_SMALL_FILE_ERROR), request);
        }
    }

    ContainerProtos.ContainerCommandResponseProto handleUnsupportedOp(ContainerProtos.ContainerCommandRequestProto request) {
        return ContainerCommandResponseBuilders.unsupportedRequest((ContainerProtos.ContainerCommandRequestProto)request);
    }

    private void checkContainerOpen(KeyValueContainer kvContainer) throws StorageContainerException {
        ContainerProtos.Result result;
        ContainerProtos.ContainerDataProto.State containerState = kvContainer.getContainerState();
        if (containerState == ContainerProtos.ContainerDataProto.State.OPEN || containerState == ContainerProtos.ContainerDataProto.State.CLOSING) {
            return;
        }
        switch (containerState) {
            case QUASI_CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case CLOSED: {
                result = ContainerProtos.Result.CLOSED_CONTAINER_IO;
                break;
            }
            case UNHEALTHY: {
                result = ContainerProtos.Result.CONTAINER_UNHEALTHY;
                break;
            }
            case INVALID: {
                result = ContainerProtos.Result.INVALID_CONTAINER_STATE;
                break;
            }
            default: {
                result = ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
            }
        }
        String msg = "Requested operation not allowed as ContainerState is " + containerState;
        throw new StorageContainerException(msg, result);
    }

    @Override
    public Container importContainer(long containerID, long maxSize, String originPipelineId, String originNodeId, InputStream rawContainerStream, TarContainerPacker packer) throws IOException {
        KeyValueContainerData containerData = new KeyValueContainerData(containerID, maxSize, originPipelineId, originNodeId);
        KeyValueContainer container = new KeyValueContainer(containerData, this.conf);
        this.populateContainerPathFields(container, maxSize);
        container.importContainerData(rawContainerStream, packer);
        this.sendICR(container);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportContainer(Container container, OutputStream outputStream, TarContainerPacker packer) throws IOException {
        container.readLock();
        try {
            KeyValueContainer kvc = (KeyValueContainer)container;
            kvc.exportContainerData(outputStream, packer);
        }
        finally {
            container.readUnlock();
        }
    }

    @Override
    public void markContainerForClose(Container container) throws IOException {
        container.writeLock();
        try {
            if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.OPEN) {
                container.markContainerForClose();
                this.sendICR(container);
            }
        }
        finally {
            container.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markContainerUnhealthy(Container container) throws IOException {
        block8: {
            container.writeLock();
            try {
                if (container.getContainerState() == ContainerProtos.ContainerDataProto.State.UNHEALTHY) break block8;
                try {
                    container.markContainerUnhealthy();
                }
                catch (IOException ex) {
                    long id = ((ContainerData)container.getContainerData()).getContainerID();
                    LOG.warn("Unexpected error while marking container " + id + " as unhealthy", (Throwable)ex);
                }
                finally {
                    this.sendICR(container);
                }
            }
            finally {
                container.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quasiCloseContainer(Container container) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (state == ContainerProtos.ContainerDataProto.State.QUASI_CLOSED) {
                return;
            }
            if (state != ContainerProtos.ContainerDataProto.State.CLOSING) {
                ContainerProtos.Result error = state == ContainerProtos.ContainerDataProto.State.INVALID ? ContainerProtos.Result.INVALID_CONTAINER_STATE : ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
                throw new StorageContainerException("Cannot quasi close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", error);
            }
            container.quasiClose();
            this.sendICR(container);
        }
        finally {
            container.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeContainer(Container container) throws IOException {
        container.writeLock();
        try {
            ContainerProtos.ContainerDataProto.State state = container.getContainerState();
            if (state == ContainerProtos.ContainerDataProto.State.CLOSED) {
                return;
            }
            if (state == ContainerProtos.ContainerDataProto.State.UNHEALTHY) {
                throw new StorageContainerException("Cannot close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", ContainerProtos.Result.CONTAINER_UNHEALTHY);
            }
            if (state != ContainerProtos.ContainerDataProto.State.CLOSING && state != ContainerProtos.ContainerDataProto.State.QUASI_CLOSED) {
                ContainerProtos.Result error = state == ContainerProtos.ContainerDataProto.State.INVALID ? ContainerProtos.Result.INVALID_CONTAINER_STATE : ContainerProtos.Result.CONTAINER_INTERNAL_ERROR;
                throw new StorageContainerException("Cannot close container #" + ((ContainerData)container.getContainerData()).getContainerID() + " while in " + state + " state.", error);
            }
            container.close();
            this.sendICR(container);
        }
        finally {
            container.writeUnlock();
        }
    }

    @Override
    public void deleteContainer(Container container, boolean force) throws IOException {
        this.deleteInternal(container, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInternal(Container container, boolean force) throws StorageContainerException {
        container.writeLock();
        try {
            if (!force && ((ContainerData)container.getContainerData()).isOpen()) {
                throw new StorageContainerException("Deletion of Open Container is not allowed.", ContainerProtos.Result.DELETE_ON_OPEN_CONTAINER);
            }
            long containerId = ((ContainerData)container.getContainerData()).getContainerID();
            this.containerSet.removeContainer(containerId);
        }
        finally {
            container.writeUnlock();
        }
        container.delete();
    }
}

