/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;

public class TarContainerPacker
implements ContainerPacker<KeyValueContainerData> {
    static final String CHUNKS_DIR_NAME = "chunks";
    static final String DB_DIR_NAME = "db";
    private static final String CONTAINER_FILE_NAME = "container.yaml";

    /*
     * Exception decompiling
     */
    @Override
    public byte[] unpackContainerData(Container<KeyValueContainerData> container, InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void extractEntry(InputStream input, long size, Path ancestor, Path path) throws IOException {
        HddsUtils.validatePath((Path)path, (Path)ancestor);
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        try (FileOutputStream fileOutput = new FileOutputStream(path.toFile());
             BufferedOutputStream output = new BufferedOutputStream(fileOutput);){
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize + 1];
            long remaining = size;
            while (remaining > 0L) {
                int len = (int)Math.min(remaining, (long)bufferSize);
                int read = input.read(buffer, 0, len);
                if (read >= 0) {
                    remaining -= (long)read;
                    ((OutputStream)output).write(buffer, 0, read);
                    continue;
                }
                remaining = 0L;
            }
        }
    }

    @Override
    public void pack(Container<KeyValueContainerData> container, OutputStream output) throws IOException {
        KeyValueContainerData containerData = container.getContainerData();
        try (OutputStream compressed = TarContainerPacker.compress(output);
             ArchiveOutputStream archiveOutput = TarContainerPacker.tar(compressed);){
            this.includePath(containerData.getDbFile().toPath(), DB_DIR_NAME, archiveOutput);
            this.includePath(Paths.get(containerData.getChunksPath(), new String[0]), CHUNKS_DIR_NAME, archiveOutput);
            TarContainerPacker.includeFile(container.getContainerFile(), CONTAINER_FILE_NAME, archiveOutput);
        }
        catch (CompressorException e) {
            throw new IOException("Can't compress the container: " + containerData.getContainerID(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] unpackContainerDescriptor(InputStream input) throws IOException {
        try (InputStream decompressed = TarContainerPacker.decompress(input);
             ArchiveInputStream archiveInput = TarContainerPacker.untar(decompressed);){
            ArchiveEntry entry = archiveInput.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (CONTAINER_FILE_NAME.equals(name)) {
                    byte[] byArray = this.readEntry((InputStream)archiveInput, entry.getSize());
                    return byArray;
                }
                entry = archiveInput.getNextEntry();
            }
            throw new IOException("Container descriptor is missing from the container archive.");
        }
        catch (CompressorException e) {
            throw new IOException("Can't read the container descriptor from the container archive", e);
        }
    }

    private byte[] readEntry(InputStream input, long size) throws IOException {
        int read;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize + 1];
        for (long remaining = size; remaining > 0L; remaining -= (long)read) {
            int len = (int)Math.min(remaining, (long)bufferSize);
            read = input.read(buffer, 0, len);
            output.write(buffer, 0, read);
        }
        return output.toByteArray();
    }

    private void includePath(Path dir, String subdir, ArchiveOutputStream archiveOutput) throws IOException {
        try (Stream<Path> dirEntries = Files.list(dir);){
            for (Path path : dirEntries.collect(Collectors.toList())) {
                String entryName = subdir + "/" + path.getFileName();
                TarContainerPacker.includeFile(path.toFile(), entryName, archiveOutput);
            }
        }
    }

    static void includeFile(File file, String entryName, ArchiveOutputStream archiveOutput) throws IOException {
        ArchiveEntry entry = archiveOutput.createArchiveEntry(file, entryName);
        archiveOutput.putArchiveEntry(entry);
        try (FileInputStream input = new FileInputStream(file);){
            IOUtils.copy((InputStream)input, (OutputStream)archiveOutput);
        }
        archiveOutput.closeArchiveEntry();
    }

    private static ArchiveInputStream untar(InputStream input) {
        return new TarArchiveInputStream(input);
    }

    private static ArchiveOutputStream tar(OutputStream output) {
        return new TarArchiveOutputStream(output);
    }

    private static InputStream decompress(InputStream input) throws CompressorException {
        return new CompressorStreamFactory().createCompressorInputStream("gz", input);
    }

    private static OutputStream compress(OutputStream output) throws CompressorException {
        return new CompressorStreamFactory().createCompressorOutputStream("gz", output);
    }
}

