/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static ReferenceCountedDB getDB(KeyValueContainerData containerData, Configuration conf) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        Preconditions.checkNotNull((Object)containerData.getDbFile());
        try {
            return cache.getDB(containerData.getContainerID(), containerData.getContainerDBType(), containerData.getDbFile().getAbsolutePath(), conf);
        }
        catch (IOException ex) {
            String message = String.format("Error opening DB. Container:%s ContainerPath:%s", containerData.getContainerID(), containerData.getDbFile().getPath());
            throw new StorageContainerException(message, ContainerProtos.Result.UNABLE_TO_READ_METADATA_DB);
        }
    }

    public static void removeDB(KeyValueContainerData container, Configuration conf) {
        Preconditions.checkNotNull((Object)container);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        cache.removeDB(container.getDbFile().getAbsolutePath());
    }

    public static void shutdownCache(ContainerCache cache) {
        cache.shutdownCache();
    }

    public static BlockData getBlockData(byte[] bytes) throws IOException {
        try {
            ContainerProtos.BlockData blockData = ContainerProtos.BlockData.parseFrom((byte[])bytes);
            return BlockData.getFromProtoBuf((ContainerProtos.BlockData)blockData);
        }
        catch (IOException e) {
            throw new StorageContainerException("Failed to parse block data from the bytes array.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
    }
}

