/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.apache.hadoop.hdds.utils.MetadataStoreBuilder;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyValueContainerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueContainerUtil.class);

    private KeyValueContainerUtil() {
    }

    public static void createContainerMetaData(File containerMetaDataPath, File chunksPath, File dbFile, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)containerMetaDataPath);
        Preconditions.checkNotNull((Object)conf);
        if (!containerMetaDataPath.mkdirs()) {
            LOG.error("Unable to create directory for metadata storage. Path: {}", (Object)containerMetaDataPath);
            throw new IOException("Unable to create directory for metadata storage. Path: " + containerMetaDataPath);
        }
        MetadataStore store = MetadataStoreBuilder.newBuilder().setConf(conf).setCreateIfMissing(true).setDbFile(dbFile).build();
        store.close();
        if (!chunksPath.mkdirs()) {
            LOG.error("Unable to create chunks directory Container {}", (Object)chunksPath);
            FileUtils.deleteDirectory((File)containerMetaDataPath);
            FileUtils.deleteDirectory((File)containerMetaDataPath.getParentFile());
            throw new IOException("Unable to create directory for data storage. Path: " + chunksPath);
        }
    }

    public static void removeContainer(KeyValueContainerData containerData, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)containerData);
        File containerMetaDataPath = new File(containerData.getMetadataPath());
        File chunksPath = new File(containerData.getChunksPath());
        BlockUtils.removeDB(containerData, conf);
        FileUtils.deleteDirectory((File)containerMetaDataPath);
        FileUtils.deleteDirectory((File)chunksPath);
        FileUtils.deleteDirectory((File)containerMetaDataPath.getParentFile());
    }

    public static void parseKVContainerData(KeyValueContainerData kvContainerData, Configuration config) throws IOException {
        long containerID = kvContainerData.getContainerID();
        File metadataPath = new File(kvContainerData.getMetadataPath());
        ContainerUtils.verifyChecksum(kvContainerData);
        File dbFile = KeyValueContainerLocationUtil.getContainerDBFile(metadataPath, containerID);
        if (!dbFile.exists()) {
            LOG.error("Container DB file is missing for ContainerID {}. Skipping loading of this container.", (Object)containerID);
            return;
        }
        kvContainerData.setDbFile(dbFile);
        try (ReferenceCountedDB metadata = BlockUtils.getDB(kvContainerData, config);){
            long bytesUsed = 0L;
            List liveKeys = metadata.getStore().getRangeKVs(null, Integer.MAX_VALUE, new MetadataKeyFilters.MetadataKeyFilter[]{MetadataKeyFilters.getNormalKeyFilter()});
            bytesUsed = liveKeys.parallelStream().mapToLong(e -> {
                try {
                    BlockData blockData = BlockUtils.getBlockData((byte[])e.getValue());
                    return blockData.getSize();
                }
                catch (IOException ex) {
                    return 0L;
                }
            }).sum();
            kvContainerData.setBytesUsed(bytesUsed);
            kvContainerData.setKeyCount(liveKeys.size());
            byte[] bcsId = metadata.getStore().get(DFSUtil.string2Bytes((String)"#BCSID"));
            if (bcsId != null) {
                kvContainerData.updateBlockCommitSequenceId(Longs.fromByteArray((byte[])bcsId));
            }
        }
    }

    public static Path getDataDirectory(KeyValueContainerData kvContainerData) {
        String chunksPath = kvContainerData.getChunksPath();
        Preconditions.checkNotNull((Object)chunksPath);
        return Paths.get(chunksPath, new String[0]);
    }

    public static Path getMetadataDirectory(KeyValueContainerData kvContainerData) {
        String metadataPath = kvContainerData.getMetadataPath();
        Preconditions.checkNotNull((Object)metadataPath);
        return Paths.get(metadataPath, new String[0]);
    }
}

