/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeIOStats;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerImpl;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkManagerDummyImpl
extends ChunkManagerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkManagerDummyImpl.class);

    public ChunkManagerDummyImpl(boolean sync) {
        super(sync);
    }

    @Override
    public void writeChunk(Container container, BlockID blockID, ChunkInfo info, ChunkBuffer data, DispatcherContext dispatcherContext) throws StorageContainerException {
        long writeTimeStart = Time.monotonicNow();
        Preconditions.checkNotNull((Object)dispatcherContext);
        DispatcherContext.WriteChunkStage stage = dispatcherContext.getStage();
        try {
            KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
            HddsVolume volume = containerData.getVolume();
            VolumeIOStats volumeIOStats = volume.getVolumeIOStats();
            switch (stage) {
                case WRITE_DATA: {
                    ChunkUtils.validateBufferSize(info, data);
                    volumeIOStats.incWriteTime(Time.monotonicNow() - writeTimeStart);
                    volumeIOStats.incWriteOpCount();
                    volumeIOStats.incWriteBytes(info.getLen());
                    break;
                }
                case COMMIT_DATA: {
                    this.updateContainerWriteStats(container, info, false);
                    break;
                }
                case COMBINED: {
                    this.updateContainerWriteStats(container, info, false);
                    break;
                }
                default: {
                    throw new IOException("Can not identify write operation.");
                }
            }
        }
        catch (IOException ex) {
            LOG.error("write data failed", (Throwable)ex);
            throw new StorageContainerException("Internal error: ", (Throwable)ex, ContainerProtos.Result.CONTAINER_INTERNAL_ERROR);
        }
    }

    @Override
    public ChunkBuffer readChunk(Container container, BlockID blockID, ChunkInfo info, DispatcherContext dispatcherContext) {
        long readStartTime = Time.monotonicNow();
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        HddsVolume volume = containerData.getVolume();
        VolumeIOStats volumeIOStats = volume.getVolumeIOStats();
        ByteBuffer data = ByteBuffer.allocate((int)info.getLen());
        volumeIOStats.incReadTime(Time.monotonicNow() - readStartTime);
        volumeIOStats.incReadOpCount();
        volumeIOStats.incReadBytes(info.getLen());
        return ChunkBuffer.wrap((ByteBuffer)data);
    }

    @Override
    public void deleteChunk(Container container, BlockID blockID, ChunkInfo info) {
        Preconditions.checkNotNull((Object)blockID, (Object)"Block ID cannot be null.");
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        if (info.getOffset() == 0L) {
            containerData.decrBytesUsed(info.getLen());
        }
    }
}

