/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerDummyImpl;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerImpl;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkManagerFactory {
    static final Logger LOG = LoggerFactory.getLogger(ChunkManagerFactory.class);
    private static volatile ChunkManager instance = null;
    private static boolean syncChunks = false;

    private ChunkManagerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ChunkManager getChunkManager(Configuration config, boolean sync) {
        if (instance == null) {
            Class<ChunkManagerFactory> clazz = ChunkManagerFactory.class;
            // MONITORENTER : org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerFactory.class
            if (instance == null) {
                instance = ChunkManagerFactory.createChunkManager(config, sync);
                syncChunks = sync;
            }
            // MONITOREXIT : clazz
        }
        Preconditions.checkArgument((syncChunks == sync ? 1 : 0) != 0, (Object)"value of sync conflicts with previous invocation");
        return instance;
    }

    private static ChunkManager createChunkManager(Configuration config, boolean sync) {
        boolean scrubber;
        ChunkManagerImpl manager = null;
        boolean persist = config.getBoolean("hdds.container.chunk.persistdata", true);
        if (!persist && (scrubber = config.getBoolean("hdds.container.scrub.enabled", false))) {
            LOG.warn("Failed to set hdds.container.chunk.persistdata to false. Please set hdds.container.scrub.enabled also to false to enable non-persistent containers.");
            persist = true;
        }
        if (persist) {
            manager = new ChunkManagerImpl(sync);
        } else {
            LOG.warn("hdds.container.chunk.persistdata is set to false. This should be used only for testing. All user data will be discarded.");
            manager = new ChunkManagerDummyImpl(sync);
        }
        return manager;
    }
}

