/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerMetadataScrubberMetrics;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScrubberConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerMetadataScanner
extends Thread {
    public static final Logger LOG = LoggerFactory.getLogger(ContainerMetadataScanner.class);
    private final ContainerController controller;
    private final long metadataScanInterval;
    private final ContainerMetadataScrubberMetrics metrics;
    private boolean stopping = false;

    public ContainerMetadataScanner(ContainerScrubberConfiguration conf, ContainerController controller) {
        this.controller = controller;
        this.metadataScanInterval = conf.getMetadataScanInterval();
        this.metrics = ContainerMetadataScrubberMetrics.create();
        this.setName("ContainerMetadataScanner");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        LOG.info("Background ContainerMetadataScanner starting up");
        try {
            while (!this.stopping) {
                this.runIteration();
                if (this.stopping) continue;
                this.metrics.resetNumUnhealthyContainers();
                this.metrics.resetNumContainersScanned();
            }
        }
        catch (Exception e) {
            LOG.error("{} exiting because of exception ", (Object)this, (Object)e);
        }
        finally {
            if (this.metrics != null) {
                this.metrics.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void runIteration() {
        long start = System.nanoTime();
        Iterator<Container<?>> containerIt = this.controller.getContainers();
        while (!this.stopping && containerIt.hasNext()) {
            Container<?> container = containerIt.next();
            try {
                this.scrub(container);
            }
            catch (IOException e) {
                LOG.info("Unexpected error while scrubbing container {}", (Object)((ContainerData)container.getContainerData()).getContainerID());
            }
            finally {
                this.metrics.incNumContainersScanned();
            }
        }
        long interval = System.nanoTime() - start;
        if (!this.stopping) {
            this.metrics.incNumScanIterations();
            LOG.info("Completed an iteration of container metadata scrubber in {} minutes. Number of  iterations (since the data-node restart) : {}, Number of containers scanned in this iteration : {}, Number of unhealthy containers found in this iteration : {}", new Object[]{TimeUnit.NANOSECONDS.toMinutes(interval), this.metrics.getNumScanIterations(), this.metrics.getNumContainersScanned(), this.metrics.getNumUnHealthyContainers()});
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(interval);
            long remainingSleep = this.metadataScanInterval - elapsedMillis;
            if (remainingSleep > 0L) {
                try {
                    Thread.sleep(remainingSleep);
                }
                catch (InterruptedException e) {
                    LOG.info("Background ContainerMetadataScanner interrupted. Going to exit");
                }
            }
        }
    }

    @VisibleForTesting
    public void scrub(Container container) throws IOException {
        if (!container.scanMetaData()) {
            this.metrics.incNumUnHealthyContainers();
            this.controller.markContainerUnhealthy(((ContainerData)container.getContainerData()).getContainerID());
        }
    }

    @VisibleForTesting
    public ContainerMetadataScrubberMetrics getMetrics() {
        return this.metrics;
    }

    public synchronized void shutdown() {
        this.stopping = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException ex) {
            LOG.warn("Unexpected exception while stopping metadata scanner.", (Throwable)ex);
        }
    }
}

