/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;

@InterfaceAudience.Private
@Metrics(about="DataNode container data scrubber metrics", context="dfs")
public final class ContainerMetadataScrubberMetrics {
    private final String name;
    private final MetricsSystem ms;
    @Metric(value={"number of containers scanned in the current iteration"})
    private MutableGaugeInt numContainersScanned;
    @Metric(value={"number of unhealthy containers found in the current iteration"})
    private MutableGaugeInt numUnHealthyContainers;
    @Metric(value={"number of iterations of scanner completed since the restart"})
    private MutableCounterInt numScanIterations;

    public int getNumContainersScanned() {
        return this.numContainersScanned.value();
    }

    public void incNumContainersScanned() {
        this.numContainersScanned.incr();
    }

    public void resetNumContainersScanned() {
        this.numContainersScanned.decr(this.getNumContainersScanned());
    }

    public int getNumUnHealthyContainers() {
        return this.numUnHealthyContainers.value();
    }

    public void incNumUnHealthyContainers() {
        this.numUnHealthyContainers.incr();
    }

    public void resetNumUnhealthyContainers() {
        this.numUnHealthyContainers.decr(this.getNumUnHealthyContainers());
    }

    public int getNumScanIterations() {
        return this.numScanIterations.value();
    }

    public void incNumScanIterations() {
        this.numScanIterations.incr();
    }

    public void unregister() {
        this.ms.unregisterSource(this.name);
    }

    public String getName() {
        return this.name;
    }

    private ContainerMetadataScrubberMetrics(String name, MetricsSystem ms) {
        this.name = name;
        this.ms = ms;
    }

    public static ContainerMetadataScrubberMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        String name = "ContainerMetadataScrubberMetrics";
        return (ContainerMetadataScrubberMetrics)ms.register(name, null, (Object)new ContainerMetadataScrubberMetrics(name, ms));
    }
}

