/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.security.token.BlockTokenVerifier;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.container.common.helpers.ContainerMetrics;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerGrpc;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.BlockDeletingService;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerDataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerMetadataScanner;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScrubberConfiguration;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationService;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.ratis.thirdparty.io.grpc.BindableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneContainer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneContainer.class);
    private final HddsDispatcher hddsDispatcher;
    private final Map<ContainerProtos.ContainerType, Handler> handlers;
    private final OzoneConfiguration config;
    private final VolumeSet volumeSet;
    private final ContainerSet containerSet;
    private final XceiverServerSpi writeChannel;
    private final XceiverServerSpi readChannel;
    private final ContainerController controller;
    private ContainerMetadataScanner metadataScanner;
    private List<ContainerDataScanner> dataScanners;
    private final BlockDeletingService blockDeletingService;

    public OzoneContainer(DatanodeDetails datanodeDetails, OzoneConfiguration conf, StateContext context, CertificateClient certClient) throws IOException {
        this.config = conf;
        this.volumeSet = new VolumeSet(datanodeDetails.getUuidString(), (Configuration)conf);
        this.containerSet = new ContainerSet();
        this.metadataScanner = null;
        this.buildContainerSet();
        ContainerMetrics metrics = ContainerMetrics.create((Configuration)conf);
        this.handlers = Maps.newHashMap();
        Consumer<StorageContainerDatanodeProtocolProtos.ContainerReplicaProto> icrSender = containerReplicaProto -> {
            StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto icr = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.newBuilder().addReport((StorageContainerDatanodeProtocolProtos.ContainerReplicaProto)containerReplicaProto).build();
            context.addReport(icr);
            context.getParent().triggerHeartbeat();
        };
        for (ContainerProtos.ContainerType containerType : ContainerProtos.ContainerType.values()) {
            this.handlers.put(containerType, Handler.getHandlerForContainerType(containerType, (Configuration)conf, context.getParent().getDatanodeDetails().getUuidString(), this.containerSet, this.volumeSet, metrics, icrSender));
        }
        SecurityConfig secConf = new SecurityConfig((Configuration)conf);
        this.hddsDispatcher = new HddsDispatcher((Configuration)this.config, this.containerSet, this.volumeSet, this.handlers, context, metrics, (TokenVerifier)(secConf.isBlockTokenEnabled() ? new BlockTokenVerifier(secConf, certClient) : null));
        this.controller = new ContainerController(this.containerSet, this.handlers);
        this.writeChannel = XceiverServerRatis.newXceiverServerRatis(datanodeDetails, this.config, this.hddsDispatcher, this.controller, certClient, context);
        this.readChannel = new XceiverServerGrpc(datanodeDetails, (Configuration)this.config, this.hddsDispatcher, certClient, new BindableService[]{this.createReplicationService()});
        long svcInterval = this.config.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
        long serviceTimeout = this.config.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
        this.blockDeletingService = new BlockDeletingService(this, svcInterval, serviceTimeout, TimeUnit.MILLISECONDS, (Configuration)this.config);
    }

    private GrpcReplicationService createReplicationService() {
        return new GrpcReplicationService(new OnDemandContainerReplicationSource(this.controller));
    }

    private void buildContainerSet() {
        Iterator<HddsVolume> volumeSetIterator = this.volumeSet.getVolumesList().iterator();
        ArrayList<Thread> volumeThreads = new ArrayList<Thread>();
        while (volumeSetIterator.hasNext()) {
            HddsVolume volume = volumeSetIterator.next();
            Thread thread = new Thread(new ContainerReader(this.volumeSet, volume, this.containerSet, this.config));
            thread.start();
            volumeThreads.add(thread);
        }
        try {
            for (int i = 0; i < volumeThreads.size(); ++i) {
                ((Thread)volumeThreads.get(i)).join();
            }
        }
        catch (InterruptedException ex) {
            LOG.info("Volume Threads Interrupted exception", (Throwable)ex);
        }
    }

    private void startContainerScrub() {
        ContainerScrubberConfiguration c = (ContainerScrubberConfiguration)this.config.getObject(ContainerScrubberConfiguration.class);
        boolean enabled = c.isEnabled();
        if (!enabled) {
            LOG.info("Background container scanner has been disabled.");
        } else {
            if (this.metadataScanner == null) {
                this.metadataScanner = new ContainerMetadataScanner(c, this.controller);
            }
            this.metadataScanner.start();
            this.dataScanners = new ArrayList<ContainerDataScanner>();
            for (HddsVolume v : this.volumeSet.getVolumesList()) {
                ContainerDataScanner s = new ContainerDataScanner(c, this.controller, v);
                s.start();
                this.dataScanners.add(s);
            }
        }
    }

    private void stopContainerScrub() {
        if (this.metadataScanner == null) {
            return;
        }
        this.metadataScanner.shutdown();
        this.metadataScanner = null;
        for (ContainerDataScanner s : this.dataScanners) {
            s.shutdown();
        }
    }

    public void start(String scmId) throws IOException {
        LOG.info("Attempting to start container services.");
        this.startContainerScrub();
        this.writeChannel.start();
        this.readChannel.start();
        this.hddsDispatcher.init();
        this.hddsDispatcher.setScmId(scmId);
        this.blockDeletingService.start();
    }

    public void stop() {
        LOG.info("Attempting to stop container services.");
        this.stopContainerScrub();
        this.writeChannel.stop();
        this.readChannel.stop();
        this.handlers.values().forEach(Handler::stop);
        this.hddsDispatcher.shutdown();
        this.volumeSet.shutdown();
        this.blockDeletingService.shutdown();
        ContainerMetrics.remove();
    }

    @VisibleForTesting
    public ContainerSet getContainerSet() {
        return this.containerSet;
    }

    public StorageContainerDatanodeProtocolProtos.PipelineReportsProto getPipelineReport() {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder pipelineReportsProto = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        pipelineReportsProto.addAllPipelineReport(this.writeChannel.getPipelineReport());
        return pipelineReportsProto.build();
    }

    public XceiverServerSpi getWriteChannel() {
        return this.writeChannel;
    }

    public XceiverServerSpi getReadChannel() {
        return this.readChannel;
    }

    public ContainerController getController() {
        return this.controller;
    }

    public StorageContainerDatanodeProtocolProtos.NodeReportProto getNodeReport() throws IOException {
        return this.volumeSet.getNodeReport();
    }

    @VisibleForTesting
    public ContainerDispatcher getDispatcher() {
        return this.hddsDispatcher;
    }

    public VolumeSet getVolumeSet() {
        return this.volumeSet;
    }
}

