/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcOutputStream.class);
    private final StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver;
    private final ByteString.Output buffer;
    private final long containerId;
    private final int bufferSize;
    private int writtenBytes;

    GrpcOutputStream(StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver, long containerId, int bufferSize) {
        this.responseObserver = responseObserver;
        this.containerId = containerId;
        this.bufferSize = bufferSize;
        this.buffer = ByteString.newOutput((int)bufferSize);
    }

    @Override
    public void write(int b) {
        try {
            this.buffer.write(b);
            if (this.buffer.size() >= this.bufferSize) {
                this.flushBuffer(false);
            }
        }
        catch (Exception ex) {
            this.responseObserver.onError((Throwable)ex);
        }
    }

    @Override
    public void write(@Nonnull byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        try {
            if (this.buffer.size() >= this.bufferSize) {
                this.flushBuffer(false);
            }
            int remaining = length;
            int off = offset;
            int len = Math.min(remaining, this.bufferSize - this.buffer.size());
            while (remaining > 0) {
                this.buffer.write(data, off, len);
                if (this.buffer.size() >= this.bufferSize) {
                    this.flushBuffer(false);
                }
                off += len;
                len = Math.min(this.bufferSize, remaining -= len);
            }
        }
        catch (Exception ex) {
            this.responseObserver.onError((Throwable)ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer(true);
        LOG.info("Sent {} bytes for container {}", (Object)this.writtenBytes, (Object)this.containerId);
        this.responseObserver.onCompleted();
        this.buffer.close();
    }

    private void flushBuffer(boolean eof) {
        int length = this.buffer.size();
        if (length > 0) {
            ByteString data = this.buffer.toByteString();
            LOG.debug("Sending {} bytes (of type {}) for container {}", new Object[]{length, data.getClass().getSimpleName(), this.containerId});
            ContainerProtos.CopyContainerResponseProto response = ContainerProtos.CopyContainerResponseProto.newBuilder().setContainerID(this.containerId).setData(data).setEof(eof).setReadOffset((long)this.writtenBytes).setLen((long)length).build();
            this.responseObserver.onNext((Object)response);
            this.writtenBytes += length;
            this.buffer.reset();
        }
    }
}

