/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;

public class OnDemandContainerReplicationSource
implements ContainerReplicationSource {
    private final ContainerController controller;
    private final TarContainerPacker packer = new TarContainerPacker();

    public OnDemandContainerReplicationSource(ContainerController controller) {
        this.controller = controller;
    }

    @Override
    public void prepare(long containerId) {
    }

    @Override
    public void copyData(long containerId, OutputStream destination) throws IOException {
        Container container = this.controller.getContainer(containerId);
        Preconditions.checkNotNull((Object)container, (Object)("Container is not found " + containerId));
        this.controller.exportContainer(container.getContainerType(), containerId, destination, this.packer);
    }
}

