/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.MappingIterator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileReader {
    private static final ObjectReader READER = new ObjectMapper().reader(DatanodeAdminProperties.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    private CombinedHostsFileReader() {
    }

    public static Set<DatanodeAdminProperties> readFile(String hostsFile) throws IOException {
        HashSet<DatanodeAdminProperties> allDNs = new HashSet<DatanodeAdminProperties>();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
            MappingIterator iterator = READER.readValues(JSON_FACTORY.createJsonParser((Reader)input));
            while (iterator.hasNext()) {
                DatanodeAdminProperties properties = (DatanodeAdminProperties)iterator.next();
                allDNs.add(properties);
            }
        }
        return allDNs;
    }
}

