/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.test.system.DNClient;
import org.apache.hadoop.hdfs.test.system.HDFSCluster;
import org.apache.hadoop.hdfs.test.system.NNClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestHL040 {
    private HDFSCluster cluster = null;
    private static final Log LOG = LogFactory.getLog(TestHL040.class);

    @Before
    public void setupUp() throws Exception {
        this.cluster = HDFSCluster.createCluster((Configuration)new Configuration());
        this.cluster.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.tearDown();
    }

    @Test
    public void testConnect() throws IOException {
        LOG.info((Object)"Staring TestHL040: connecting to the HDFSCluster ");
        LOG.info((Object)"================ Getting namenode info ================");
        NNClient dfsMaster = this.cluster.getNNClient();
        LOG.info((Object)("Process info of namenode " + dfsMaster.getHostName() + " is: " + dfsMaster.getProcessInfo()));
        LOG.info((Object)"================ Getting datanode info ================");
        List clients = this.cluster.getDNClients();
        for (DNClient dnC : clients) {
            LOG.info((Object)("Process info of datanode " + dnC.getHostName() + " is: " + dnC.getProcessInfo()));
            Assert.assertNotNull((String)"Datanode process info isn't suppose to be null", (Object)dnC.getProcessInfo());
            LOG.info((Object)("Free space " + this.getFreeSpace(dnC)));
        }
    }

    private long getFreeSpace(DNClient dnC) throws IOException {
        Object volObj = dnC.getDaemonAttribute("VolumeInfo");
        Assert.assertNotNull((String)"Attribute value is expected to be not null", (Object)volObj);
        LOG.debug((Object)("Got object: " + volObj));
        Map volInfoMap = (Map)JSON.parse((String)volObj.toString());
        long totalFreeSpace = 0L;
        for (Object key : volInfoMap.keySet()) {
            Map attrMap = (Map)volInfoMap.get(key);
            long freeSpace = (Long)attrMap.get("freeSpace");
            totalFreeSpace += freeSpace;
        }
        return totalFreeSpace;
    }
}

