/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.net.Proxy;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.JobEndNotifier;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.TestJobEndNotifier;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.yarn.event.Event;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobEndNotifier
extends JobEndNotifier {
    protected int notificationCount = 0;

    private void testNumRetries(Configuration conf) {
        conf.set("mapreduce.job.end-notification.max.attempts", "0");
        conf.set("mapreduce.job.end-notification.retry.attempts", "10");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected numTries to be 0, but was " + this.numTries), (this.numTries == 0 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.max.attempts", "1");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected numTries to be 1, but was " + this.numTries), (this.numTries == 1 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.max.attempts", "20");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected numTries to be 11, but was " + this.numTries), (this.numTries == 11 ? 1 : 0) != 0);
    }

    private void testWaitInterval(Configuration conf) {
        conf.set("mapreduce.job.end-notification.max.retry.interval", "5000");
        conf.set("mapreduce.job.end-notification.retry.interval", "1000");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected waitInterval to be 1000, but was " + this.waitInterval), (this.waitInterval == 1000 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.retry.interval", "10000");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected waitInterval to be 5000, but was " + this.waitInterval), (this.waitInterval == 5000 ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.retry.interval", "-10");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected waitInterval to be 5000, but was " + this.waitInterval), (this.waitInterval == 5000 ? 1 : 0) != 0);
    }

    private void testTimeout(Configuration conf) {
        conf.set("mapreduce.job.end-notification.timeout", "1000");
        this.setConf(conf);
        Assert.assertTrue((String)("Expected timeout to be 1000, but was " + this.timeout), (this.timeout == 1000 ? 1 : 0) != 0);
    }

    private void testProxyConfiguration(Configuration conf) {
        conf.set("mapreduce.job.end-notification.proxy", "somehost");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy shouldn't be set because port wasn't specified", (this.proxyToUse.type() == Proxy.Type.DIRECT ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.proxy", "somehost:someport");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy shouldn't be set because port wasn't numeric", (this.proxyToUse.type() == Proxy.Type.DIRECT ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.proxy", "somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been set but wasn't ", (boolean)this.proxyToUse.toString().equals("HTTP @ somehost:1000"));
        conf.set("mapreduce.job.end-notification.proxy", "socks@somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been socks but wasn't ", (boolean)this.proxyToUse.toString().equals("SOCKS @ somehost:1000"));
        conf.set("mapreduce.job.end-notification.proxy", "SOCKS@somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been socks but wasn't ", (boolean)this.proxyToUse.toString().equals("SOCKS @ somehost:1000"));
        conf.set("mapreduce.job.end-notification.proxy", "sfafn@somehost:1000");
        this.setConf(conf);
        Assert.assertTrue((String)"Proxy should have been http but wasn't ", (boolean)this.proxyToUse.toString().equals("HTTP @ somehost:1000"));
    }

    @Test
    public void checkConfiguration() {
        Configuration conf = new Configuration();
        this.testNumRetries(conf);
        this.testWaitInterval(conf);
        this.testTimeout(conf);
        this.testProxyConfiguration(conf);
    }

    protected boolean notifyURLOnce() {
        boolean success = super.notifyURLOnce();
        ++this.notificationCount;
        return success;
    }

    @Test
    public void testNotifyRetries() throws InterruptedException {
        JobConf conf = new JobConf();
        conf.set("mapreduce.job.end-notification.retry.attempts", "0");
        conf.set("mapreduce.job.end-notification.max.attempts", "1");
        conf.set("mapreduce.job.end-notification.url", "http://nonexistent");
        conf.set("mapreduce.job.end-notification.retry.interval", "5000");
        conf.set("mapreduce.job.end-notification.max.retry.interval", "5000");
        JobReport jobReport = (JobReport)Mockito.mock(JobReport.class);
        long startTime = System.currentTimeMillis();
        this.notificationCount = 0;
        this.setConf((Configuration)conf);
        this.notify(jobReport);
        long endTime = System.currentTimeMillis();
        Assert.assertEquals((String)("Only 1 try was expected but was : " + this.notificationCount), (long)1L, (long)this.notificationCount);
        Assert.assertTrue((String)("Should have taken more than 5 seconds it took " + (endTime - startTime)), (endTime - startTime > 5000L ? 1 : 0) != 0);
        conf.set("mapreduce.job.end-notification.max.attempts", "3");
        conf.set("mapreduce.job.end-notification.retry.attempts", "3");
        conf.set("mapreduce.job.end-notification.retry.interval", "3000");
        conf.set("mapreduce.job.end-notification.max.retry.interval", "3000");
        startTime = System.currentTimeMillis();
        this.notificationCount = 0;
        this.setConf((Configuration)conf);
        this.notify(jobReport);
        endTime = System.currentTimeMillis();
        Assert.assertEquals((String)("Only 3 retries were expected but was : " + this.notificationCount), (long)3L, (long)this.notificationCount);
        Assert.assertTrue((String)("Should have taken more than 9 seconds it took " + (endTime - startTime)), (endTime - startTime > 9000L ? 1 : 0) != 0);
    }

    @Test
    public void testNotificationOnLastRetryNormalShutdown() throws Exception {
        HttpServer2 server = TestJobEndNotifier.startHttpServer();
        MRApp app = (MRApp)Mockito.spy((Object)new MRAppWithCustomContainerAllocator(this, 2, 2, true, this.getClass().getName(), true, 2, true));
        ((MRApp)Mockito.doNothing().when((Object)app)).sysexit();
        JobConf conf = new JobConf();
        conf.set("mapreduce.job.end-notification.url", JobEndServlet.baseUrl + "jobend?jobid=$jobId&status=$jobStatus");
        JobImpl job = (JobImpl)app.submit((Configuration)conf);
        app.waitForInternalState(job, JobStateInternal.SUCCEEDED);
        app.shutDownJob();
        Assert.assertTrue((boolean)app.isLastAMRetry());
        Assert.assertEquals((long)1L, (long)JobEndServlet.calledTimes);
        Assert.assertEquals((Object)("jobid=" + job.getID() + "&status=SUCCEEDED"), (Object)JobEndServlet.requestUri.getQuery());
        Assert.assertEquals((Object)JobState.SUCCEEDED.toString(), (Object)JobEndServlet.foundJobState);
        server.stop();
    }

    @Test
    public void testAbsentNotificationOnNotLastRetryUnregistrationFailure() throws Exception {
        HttpServer2 server = TestJobEndNotifier.startHttpServer();
        MRApp app = (MRApp)Mockito.spy((Object)new MRAppWithCustomContainerAllocator(this, 2, 2, false, this.getClass().getName(), true, 1, false));
        ((MRApp)Mockito.doNothing().when((Object)app)).sysexit();
        JobConf conf = new JobConf();
        conf.set("mapreduce.job.end-notification.url", JobEndServlet.baseUrl + "jobend?jobid=$jobId&status=$jobStatus");
        JobImpl job = (JobImpl)app.submit((Configuration)conf);
        app.waitForState((Job)job, JobState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new JobEvent(app.getJobId(), JobEventType.JOB_AM_REBOOT));
        app.waitForInternalState(job, JobStateInternal.REBOOT);
        app.shutDownJob();
        app.waitForState((Job)job, JobState.RUNNING);
        Assert.assertFalse((boolean)app.isLastAMRetry());
        Assert.assertEquals((long)0L, (long)JobEndServlet.calledTimes);
        Assert.assertNull((Object)JobEndServlet.requestUri);
        Assert.assertNull((Object)JobEndServlet.foundJobState);
        server.stop();
    }

    @Test
    public void testNotificationOnLastRetryUnregistrationFailure() throws Exception {
        HttpServer2 server = TestJobEndNotifier.startHttpServer();
        MRApp app = (MRApp)Mockito.spy((Object)new MRAppWithCustomContainerAllocator(this, 2, 2, false, this.getClass().getName(), true, 2, false));
        app.isLastAMRetry = true;
        ((MRApp)Mockito.doNothing().when((Object)app)).sysexit();
        JobConf conf = new JobConf();
        conf.set("mapreduce.job.end-notification.url", JobEndServlet.baseUrl + "jobend?jobid=$jobId&status=$jobStatus");
        JobImpl job = (JobImpl)app.submit((Configuration)conf);
        app.waitForState((Job)job, JobState.RUNNING);
        app.getContext().getEventHandler().handle((Event)new JobEvent(app.getJobId(), JobEventType.JOB_AM_REBOOT));
        app.waitForInternalState(job, JobStateInternal.REBOOT);
        app.waitForServiceToStop(10000L);
        Assert.assertFalse((boolean)app.isLastAMRetry());
        Assert.assertEquals((long)0L, (long)JobEndServlet.calledTimes);
        Assert.assertNull((Object)JobEndServlet.requestUri);
        Assert.assertNull((Object)JobEndServlet.foundJobState);
        server.stop();
    }

    private static HttpServer2 startHttpServer() throws Exception {
        new File(System.getProperty("build.webapps", "build/webapps") + "/test").mkdirs();
        HttpServer2 server = new HttpServer2.Builder().setName("test").addEndpoint(URI.create("http://localhost:0")).setFindPort(true).build();
        server.addServlet("jobend", "/jobend", JobEndServlet.class);
        server.start();
        JobEndServlet.calledTimes = 0;
        JobEndServlet.requestUri = null;
        JobEndServlet.baseUrl = "http://localhost:" + server.getConnectorAddress(0).getPort() + "/";
        JobEndServlet.foundJobState = null;
        return server;
    }
}

