/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.local;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.app.local.TestLocalContainerAllocator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestLocalContainerAllocator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMConnectionRetry() throws Exception {
        ApplicationMasterProtocol mockScheduler = (ApplicationMasterProtocol)Mockito.mock(ApplicationMasterProtocol.class);
        Mockito.when((Object)mockScheduler.allocate((AllocateRequest)Matchers.isA(AllocateRequest.class))).thenThrow(new Throwable[]{RPCUtil.getRemoteException((Throwable)new IOException("forcefail"))});
        Configuration conf = new Configuration();
        StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator(mockScheduler);
        lca.init(conf);
        lca.start();
        try {
            lca.heartbeat();
            Assert.fail((String)"heartbeat was supposed to throw");
        }
        catch (YarnException yarnException) {
        }
        finally {
            lca.stop();
        }
        conf.setLong("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 0L);
        lca = new StubbedLocalContainerAllocator(mockScheduler);
        lca.init(conf);
        lca.start();
        try {
            lca.heartbeat();
            Assert.fail((String)"heartbeat was supposed to throw");
        }
        catch (YarnRuntimeException yarnRuntimeException) {
        }
        finally {
            lca.stop();
        }
    }

    @Test
    public void testAllocResponseId() throws Exception {
        MockScheduler scheduler = new MockScheduler(null);
        Configuration conf = new Configuration();
        StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator((ApplicationMasterProtocol)scheduler);
        lca.init(conf);
        lca.start();
        lca.heartbeat();
        lca.heartbeat();
        lca.close();
    }

    @Test
    public void testAMRMTokenUpdate() throws Exception {
        Configuration conf = new Configuration();
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1L, (int)1), (int)1);
        AMRMTokenIdentifier oldTokenId = new AMRMTokenIdentifier(attemptId, 1);
        AMRMTokenIdentifier newTokenId = new AMRMTokenIdentifier(attemptId, 2);
        Token oldToken = new Token(oldTokenId.getBytes(), "oldpassword".getBytes(), oldTokenId.getKind(), new Text());
        Token newToken = new Token(newTokenId.getBytes(), "newpassword".getBytes(), newTokenId.getKind(), new Text());
        MockScheduler scheduler = new MockScheduler(null);
        scheduler.amToken = newToken;
        StubbedLocalContainerAllocator lca = new StubbedLocalContainerAllocator((ApplicationMasterProtocol)scheduler);
        lca.init(conf);
        lca.start();
        UserGroupInformation testUgi = UserGroupInformation.createUserForTesting((String)"someuser", (String[])new String[0]);
        testUgi.addToken(oldToken);
        testUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        lca.close();
        int tokenCount = 0;
        Token ugiToken = null;
        for (Token token : testUgi.getTokens()) {
            if (!AMRMTokenIdentifier.KIND_NAME.equals((Object)token.getKind())) continue;
            ugiToken = token;
            ++tokenCount;
        }
        Assert.assertEquals((String)"too many AMRM tokens", (long)1L, (long)tokenCount);
        Assert.assertArrayEquals((String)"token identifier not updated", (byte[])newToken.getIdentifier(), (byte[])ugiToken.getIdentifier());
        Assert.assertArrayEquals((String)"token password not updated", (byte[])newToken.getPassword(), (byte[])ugiToken.getPassword());
        Assert.assertEquals((String)"AMRM token service not updated", (Object)new Text(ClientRMProxy.getAMRMTokenService((Configuration)conf)), (Object)ugiToken.getService());
    }
}

