/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;

public abstract class RMContainerRequestor
extends RMCommunicator {
    private static final Log LOG = LogFactory.getLog(RMContainerRequestor.class);
    private static final ResourceRequest.ResourceRequestComparator RESOURCE_REQUEST_COMPARATOR = new ResourceRequest.ResourceRequestComparator();
    protected int lastResponseID;
    private Resource availableResources;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final Map<Priority, Map<String, Map<Resource, ResourceRequest>>> remoteRequestsTable = new TreeMap();
    private final Set<ResourceRequest> ask = new TreeSet(RESOURCE_REQUEST_COMPARATOR);
    private final Set<ContainerId> release = new TreeSet();
    protected Set<ContainerId> pendingRelease = new TreeSet();
    private final Map<ResourceRequest, ResourceRequest> requestLimits = new TreeMap(RESOURCE_REQUEST_COMPARATOR);
    private final Set<ResourceRequest> requestLimitsToUpdate = new TreeSet(RESOURCE_REQUEST_COMPARATOR);
    private boolean nodeBlacklistingEnabled;
    private int blacklistDisablePercent;
    private AtomicBoolean ignoreBlacklisting = new AtomicBoolean(false);
    private int blacklistedNodeCount = 0;
    private int lastClusterNmCount = 0;
    private int clusterNmCount = 0;
    private int maxTaskFailuresPerNode;
    private final Map<String, Integer> nodeFailures = new HashMap();
    private final Set<String> blacklistedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> blacklistAdditions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> blacklistRemovals = Collections.newSetFromMap(new ConcurrentHashMap());

    public RMContainerRequestor(ClientService clientService, AppContext context) {
        super(clientService, context);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.nodeBlacklistingEnabled = conf.getBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        LOG.info((Object)("nodeBlacklistingEnabled:" + this.nodeBlacklistingEnabled));
        this.maxTaskFailuresPerNode = conf.getInt("mapreduce.job.maxtaskfailures.per.tracker", 3);
        this.blacklistDisablePercent = conf.getInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", 33);
        LOG.info((Object)("maxTaskFailuresPerNode is " + this.maxTaskFailuresPerNode));
        if (this.blacklistDisablePercent < -1 || this.blacklistDisablePercent > 100) {
            throw new YarnRuntimeException("Invalid blacklistDisablePercent: " + this.blacklistDisablePercent + ". Should be an integer between 0 and 100 or -1 to disabled");
        }
        LOG.info((Object)("blacklistDisablePercent is " + this.blacklistDisablePercent));
    }

    protected AllocateResponse makeRemoteRequest() throws YarnException, IOException {
        this.applyRequestLimits();
        ResourceBlacklistRequest blacklistRequest = ResourceBlacklistRequest.newInstance(new ArrayList(this.blacklistAdditions), new ArrayList(this.blacklistRemovals));
        AllocateRequest allocateRequest = AllocateRequest.newInstance((int)this.lastResponseID, (float)super.getApplicationProgress(), new ArrayList(this.ask), new ArrayList(this.release), (ResourceBlacklistRequest)blacklistRequest);
        AllocateResponse allocateResponse = this.scheduler.allocate(allocateRequest);
        this.lastResponseID = allocateResponse.getResponseId();
        this.availableResources = allocateResponse.getAvailableResources();
        this.lastClusterNmCount = this.clusterNmCount;
        this.clusterNmCount = allocateResponse.getNumClusterNodes();
        int numCompletedContainers = allocateResponse.getCompletedContainersStatuses().size();
        if (this.ask.size() > 0 || this.release.size() > 0) {
            LOG.info((Object)("getResources() for " + this.applicationId + ":" + " ask=" + this.ask.size() + " release= " + this.release.size() + " newContainers=" + allocateResponse.getAllocatedContainers().size() + " finishedContainers=" + numCompletedContainers + " resourcelimit=" + this.availableResources + " knownNMs=" + this.clusterNmCount));
        }
        this.ask.clear();
        this.release.clear();
        if (numCompletedContainers > 0) {
            this.requestLimitsToUpdate.addAll(this.requestLimits.keySet());
        }
        if (this.blacklistAdditions.size() > 0 || this.blacklistRemovals.size() > 0) {
            LOG.info((Object)("Update the blacklist for " + this.applicationId + ": blacklistAdditions=" + this.blacklistAdditions.size() + " blacklistRemovals=" + this.blacklistRemovals.size()));
        }
        this.blacklistAdditions.clear();
        this.blacklistRemovals.clear();
        return allocateResponse;
    }

    private void applyRequestLimits() {
        Iterator iter = this.requestLimits.values().iterator();
        while (iter.hasNext()) {
            ResourceRequest reqLimit = (ResourceRequest)iter.next();
            int limit = reqLimit.getNumContainers();
            Map remoteRequests = (Map)this.remoteRequestsTable.get(reqLimit.getPriority());
            Map reqMap = remoteRequests != null ? (Map)remoteRequests.get("*") : null;
            ResourceRequest req = reqMap != null ? (ResourceRequest)reqMap.get(reqLimit.getCapability()) : null;
            if (req == null) continue;
            if (this.ask.remove(req) || this.requestLimitsToUpdate.contains(req)) {
                ResourceRequest newReq = req.getNumContainers() > limit ? reqLimit : req;
                this.ask.add(newReq);
                LOG.info((Object)("Applying ask limit of " + newReq.getNumContainers() + " for priority:" + reqLimit.getPriority() + " and capability:" + reqLimit.getCapability()));
            }
            if (limit != Integer.MAX_VALUE) continue;
            iter.remove();
        }
        this.requestLimitsToUpdate.clear();
    }

    protected void addOutstandingRequestOnResync() {
        for (Map rr : this.remoteRequestsTable.values()) {
            for (Map capabalities : rr.values()) {
                for (ResourceRequest request : capabalities.values()) {
                    this.addResourceRequestToAsk(request);
                }
            }
        }
        if (!this.ignoreBlacklisting.get()) {
            this.blacklistAdditions.addAll(this.blacklistedNodes);
        }
        if (!this.pendingRelease.isEmpty()) {
            this.release.addAll(this.pendingRelease);
        }
        this.requestLimitsToUpdate.addAll(this.requestLimits.keySet());
    }

    protected void computeIgnoreBlacklisting() {
        if (!this.nodeBlacklistingEnabled) {
            return;
        }
        if (this.blacklistDisablePercent != -1 && (this.blacklistedNodeCount != this.blacklistedNodes.size() || this.clusterNmCount != this.lastClusterNmCount)) {
            this.blacklistedNodeCount = this.blacklistedNodes.size();
            if (this.clusterNmCount == 0) {
                LOG.info((Object)"KnownNode Count at 0. Not computing ignoreBlacklisting");
                return;
            }
            int val = (int)((float)this.blacklistedNodes.size() / (float)this.clusterNmCount * 100.0f);
            if (val >= this.blacklistDisablePercent) {
                if (this.ignoreBlacklisting.compareAndSet(false, true)) {
                    LOG.info((Object)("Ignore blacklisting set to true. Known: " + this.clusterNmCount + ", Blacklisted: " + this.blacklistedNodeCount + ", " + val + "%"));
                    this.blacklistAdditions.clear();
                    this.blacklistRemovals.addAll(this.blacklistedNodes);
                }
            } else if (this.ignoreBlacklisting.compareAndSet(true, false)) {
                LOG.info((Object)("Ignore blacklisting set to false. Known: " + this.clusterNmCount + ", Blacklisted: " + this.blacklistedNodeCount + ", " + val + "%"));
                this.blacklistAdditions.addAll(this.blacklistedNodes);
                this.blacklistRemovals.clear();
            }
        }
    }

    protected void containerFailedOnHost(String hostName) {
        if (!this.nodeBlacklistingEnabled) {
            return;
        }
        if (this.blacklistedNodes.contains(hostName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Host " + hostName + " is already blacklisted."));
            }
            return;
        }
        Integer failures = (Integer)this.nodeFailures.remove(hostName);
        failures = failures == null ? Integer.valueOf(0) : failures;
        Integer n = failures;
        Integer n2 = failures = Integer.valueOf(failures + 1);
        LOG.info((Object)(failures + " failures on node " + hostName));
        if (failures >= this.maxTaskFailuresPerNode) {
            this.blacklistedNodes.add(hostName);
            if (!this.ignoreBlacklisting.get()) {
                this.blacklistAdditions.add(hostName);
            }
            LOG.info((Object)("Blacklisted host " + hostName));
            for (Map remoteRequests : this.remoteRequestsTable.values()) {
                boolean foundAll = true;
                Map reqMap = (Map)remoteRequests.get(hostName);
                if (reqMap == null) continue;
                for (ResourceRequest req : reqMap.values()) {
                    if (this.ask.remove(req)) continue;
                    foundAll = false;
                    ResourceRequest zeroedRequest = ResourceRequest.newInstance((Priority)req.getPriority(), (String)req.getResourceName(), (Resource)req.getCapability(), (int)req.getNumContainers(), (boolean)req.getRelaxLocality());
                    zeroedRequest.setNumContainers(0);
                    this.addResourceRequestToAsk(zeroedRequest);
                }
                if (!foundAll) continue;
                remoteRequests.remove(hostName);
            }
        } else {
            this.nodeFailures.put(hostName, failures);
        }
    }

    protected Resource getAvailableResources() {
        return this.availableResources;
    }

    protected void addContainerReq(ContainerRequest req) {
        for (String host : req.hosts) {
            if (this.isNodeBlacklisted(host)) continue;
            this.addResourceRequest(req.priority, host, req.capability);
        }
        for (String rack : req.racks) {
            this.addResourceRequest(req.priority, rack, req.capability);
        }
        this.addResourceRequest(req.priority, "*", req.capability);
    }

    protected void decContainerReq(ContainerRequest req) {
        for (String hostName : req.hosts) {
            this.decResourceRequest(req.priority, hostName, req.capability);
        }
        for (String rack : req.racks) {
            this.decResourceRequest(req.priority, rack, req.capability);
        }
        this.decResourceRequest(req.priority, "*", req.capability);
    }

    private void addResourceRequest(Priority priority, String resourceName, Resource capability) {
        ResourceRequest remoteRequest;
        HashMap<Resource, ResourceRequest> reqMap;
        HashMap remoteRequests = (HashMap)this.remoteRequestsTable.get(priority);
        if (remoteRequests == null) {
            remoteRequests = new HashMap();
            this.remoteRequestsTable.put(priority, remoteRequests);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added priority=" + priority));
            }
        }
        if ((reqMap = (HashMap<Resource, ResourceRequest>)remoteRequests.get(resourceName)) == null) {
            reqMap = new HashMap<Resource, ResourceRequest>();
            remoteRequests.put(resourceName, reqMap);
        }
        if ((remoteRequest = (ResourceRequest)reqMap.get(capability)) == null) {
            remoteRequest = (ResourceRequest)this.recordFactory.newRecordInstance(ResourceRequest.class);
            remoteRequest.setPriority(priority);
            remoteRequest.setResourceName(resourceName);
            remoteRequest.setCapability(capability);
            remoteRequest.setNumContainers(0);
            reqMap.put(capability, remoteRequest);
        }
        remoteRequest.setNumContainers(remoteRequest.getNumContainers() + 1);
        this.addResourceRequestToAsk(remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, Resource capability) {
        Map remoteRequests = (Map)this.remoteRequestsTable.get(priority);
        Map reqMap = (Map)remoteRequests.get(resourceName);
        if (reqMap == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not decrementing resource as " + resourceName + " is not present in request table"));
            }
            return;
        }
        ResourceRequest remoteRequest = (ResourceRequest)reqMap.get(capability);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("BEFORE decResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
        if (remoteRequest.getNumContainers() > 0) {
            remoteRequest.setNumContainers(remoteRequest.getNumContainers() - 1);
        }
        if (remoteRequest.getNumContainers() == 0) {
            reqMap.remove(capability);
            if (reqMap.size() == 0) {
                remoteRequests.remove(resourceName);
            }
            if (remoteRequests.size() == 0) {
                this.remoteRequestsTable.remove(priority);
            }
        }
        this.addResourceRequestToAsk(remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("AFTER decResourceRequest: applicationId=" + this.applicationId.getId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + remoteRequest.getNumContainers() + " #asks=" + this.ask.size()));
        }
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        this.ask.remove(remoteRequest);
        this.ask.add(remoteRequest);
    }

    protected void release(ContainerId containerId) {
        this.release.add(containerId);
    }

    protected boolean isNodeBlacklisted(String hostname) {
        if (!this.nodeBlacklistingEnabled || this.ignoreBlacklisting.get()) {
            return false;
        }
        return this.blacklistedNodes.contains(hostname);
    }

    protected ContainerRequest getFilteredContainerRequest(ContainerRequest orig) {
        ArrayList<String> newHosts = new ArrayList<String>();
        for (String host : orig.hosts) {
            if (this.isNodeBlacklisted(host)) continue;
            newHosts.add(host);
        }
        String[] hosts = newHosts.toArray(new String[newHosts.size()]);
        ContainerRequest newReq = new ContainerRequest(orig.attemptID, orig.capability, hosts, orig.racks, orig.priority);
        return newReq;
    }

    protected void setRequestLimit(Priority priority, Resource capability, int limit) {
        ResourceRequest newReqLimit;
        ResourceRequest oldReqLimit;
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        if ((oldReqLimit = this.requestLimits.put(newReqLimit = ResourceRequest.newInstance((Priority)priority, (String)"*", (Resource)capability, (int)limit), newReqLimit)) == null || oldReqLimit.getNumContainers() < limit) {
            this.requestLimitsToUpdate.add(newReqLimit);
        }
    }

    public Set<String> getBlacklistedNodes() {
        return this.blacklistedNodes;
    }
}

