/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptDiagnosticsUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHeartbeatHandler
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(TaskHeartbeatHandler.class);
    private Thread lostTaskCheckerThread;
    private volatile boolean stopped;
    private long taskTimeOut;
    private long unregisterTimeOut;
    private long taskStuckTimeOut;
    private int taskTimeOutCheckInterval = 30000;
    private final EventHandler eventHandler;
    private final Clock clock;
    private ConcurrentMap<TaskAttemptId, ReportTime> runningAttempts;
    private ConcurrentMap<TaskAttemptId, ReportTime> recentlyUnregisteredAttempts;

    public TaskHeartbeatHandler(EventHandler eventHandler, Clock clock, int numThreads) {
        super("TaskHeartbeatHandler");
        this.eventHandler = eventHandler;
        this.clock = clock;
        this.runningAttempts = new ConcurrentHashMap<TaskAttemptId, ReportTime>(16, 0.75f, numThreads);
        this.recentlyUnregisteredAttempts = new ConcurrentHashMap<TaskAttemptId, ReportTime>(16, 0.75f, numThreads);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        this.taskTimeOut = conf.getLong("mapreduce.task.timeout", 300000L);
        this.unregisterTimeOut = conf.getLong("mapreduce.task.exit.timeout", 60000L);
        this.taskStuckTimeOut = conf.getLong("mapreduce.task.stuck.timeout-ms", 600000L);
        long taskProgressReportIntervalMillis = MRJobConfUtil.getTaskProgressReportInterval((Configuration)conf);
        long minimumTaskTimeoutAllowed = taskProgressReportIntervalMillis * 2L;
        if (this.taskTimeOut < minimumTaskTimeoutAllowed) {
            this.taskTimeOut = minimumTaskTimeoutAllowed;
            LOG.info("Task timeout must be as least twice as long as the task status report interval. Setting task timeout to " + this.taskTimeOut);
        }
        this.taskTimeOutCheckInterval = conf.getInt("mapreduce.task.timeout.check-interval-ms", 30000);
    }

    protected void serviceStart() throws Exception {
        this.lostTaskCheckerThread = new Thread(new PingChecker());
        this.lostTaskCheckerThread.setName("TaskHeartbeatHandler PingChecker");
        this.lostTaskCheckerThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.lostTaskCheckerThread != null) {
            this.lostTaskCheckerThread.interrupt();
        }
        super.serviceStop();
    }

    public void progressing(TaskAttemptId attemptID) {
        ReportTime time = (ReportTime)this.runningAttempts.get(attemptID);
        if (time != null) {
            time.reported.compareAndSet(false, true);
            time.setLastProgress(this.clock.getTime());
        }
    }

    public void register(TaskAttemptId attemptID) {
        this.runningAttempts.put(attemptID, new ReportTime(this.clock.getTime()));
    }

    public void unregister(TaskAttemptId attemptID) {
        this.runningAttempts.remove(attemptID);
        this.recentlyUnregisteredAttempts.put(attemptID, new ReportTime(this.clock.getTime()));
    }

    public boolean hasRecentlyUnregistered(TaskAttemptId attemptID) {
        return this.recentlyUnregisteredAttempts.containsKey(attemptID);
    }

    @VisibleForTesting
    ConcurrentMap<TaskAttemptId, ReportTime> getRunningAttempts() {
        return this.runningAttempts;
    }

    @VisibleForTesting
    public long getTaskTimeOut() {
        return this.taskTimeOut;
    }

    private class PingChecker
    implements Runnable {
        private PingChecker() {
        }

        @Override
        public void run() {
            while (!TaskHeartbeatHandler.this.stopped && !Thread.currentThread().isInterrupted()) {
                long currentTime = TaskHeartbeatHandler.this.clock.getTime();
                this.checkRunning(currentTime);
                this.checkRecentlyUnregistered(currentTime);
                try {
                    Thread.sleep(TaskHeartbeatHandler.this.taskTimeOutCheckInterval);
                }
                catch (InterruptedException e) {
                    LOG.info("TaskHeartbeatHandler thread interrupted");
                    break;
                }
            }
        }

        private void checkRunning(long currentTime) {
            Iterator iterator = TaskHeartbeatHandler.this.runningAttempts.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean taskStuck;
                Map.Entry entry = iterator.next();
                boolean taskTimedOut = TaskHeartbeatHandler.this.taskTimeOut > 0L && currentTime > ((ReportTime)entry.getValue()).getLastProgress() + TaskHeartbeatHandler.this.taskTimeOut;
                boolean bl = taskStuck = TaskHeartbeatHandler.this.taskStuckTimeOut > 0L && !((ReportTime)entry.getValue()).isReported() && currentTime > ((ReportTime)entry.getValue()).getLastProgress() + TaskHeartbeatHandler.this.taskStuckTimeOut;
                if (!taskTimedOut && !taskStuck) continue;
                iterator.remove();
                TaskHeartbeatHandler.this.eventHandler.handle((Event)new TaskAttemptDiagnosticsUpdateEvent((TaskAttemptId)entry.getKey(), "AttemptID:" + ((TaskAttemptId)entry.getKey()).toString() + " task timeout set: " + TaskHeartbeatHandler.this.taskTimeOut / 1000L + "s, taskTimedOut: " + taskTimedOut + "; task stuck timeout set: " + TaskHeartbeatHandler.this.taskStuckTimeOut / 1000L + "s, taskStuck: " + taskStuck));
                TaskHeartbeatHandler.this.eventHandler.handle((Event)new TaskAttemptEvent((TaskAttemptId)entry.getKey(), TaskAttemptEventType.TA_TIMED_OUT));
            }
        }

        private void checkRecentlyUnregistered(long currentTime) {
            Iterator iterator = TaskHeartbeatHandler.this.recentlyUnregisteredAttempts.values().iterator();
            while (iterator.hasNext()) {
                ReportTime unregisteredTime = (ReportTime)iterator.next();
                if (currentTime <= unregisteredTime.getLastProgress() + TaskHeartbeatHandler.this.unregisterTimeOut) continue;
                iterator.remove();
            }
        }
    }

    static class ReportTime {
        private long lastProgress;
        private final AtomicBoolean reported;

        public ReportTime(long time) {
            this.setLastProgress(time);
            this.reported = new AtomicBoolean(false);
        }

        public synchronized void setLastProgress(long time) {
            this.lastProgress = time;
        }

        public synchronized long getLastProgress() {
            return this.lastProgress;
        }

        public boolean isReported() {
            return this.reported.get();
        }
    }
}

