/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.EventFetcher;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.Fetcher;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;
import org.apache.hadoop.util.Progress;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Shuffle<K, V>
implements ExceptionReporter {
    private static final int PROGRESS_FREQUENCY = 2000;
    private final TaskAttemptID reduceId;
    private final JobConf jobConf;
    private final Reporter reporter;
    private final ShuffleClientMetrics metrics;
    private final TaskUmbilicalProtocol umbilical;
    private final ShuffleScheduler<K, V> scheduler;
    private final MergeManager<K, V> merger;
    private Throwable throwable = null;
    private String throwingThreadName = null;
    private final Progress copyPhase;
    private final TaskStatus taskStatus;
    private final Task reduceTask;

    public Shuffle(TaskAttemptID reduceId, JobConf jobConf, FileSystem localFS, TaskUmbilicalProtocol umbilical, LocalDirAllocator localDirAllocator, Reporter reporter, CompressionCodec codec, Class<? extends Reducer> combinerClass, Task.CombineOutputCollector<K, V> combineCollector, Counters.Counter spilledRecordsCounter, Counters.Counter reduceCombineInputCounter, Counters.Counter shuffledMapsCounter, Counters.Counter reduceShuffleBytes, Counters.Counter failedShuffleCounter, Counters.Counter mergedMapOutputsCounter, TaskStatus status, Progress copyPhase, Progress mergePhase, Task reduceTask, MapOutputFile mapOutputFile) {
        this.reduceId = reduceId;
        this.jobConf = jobConf;
        this.umbilical = umbilical;
        this.reporter = reporter;
        this.metrics = new ShuffleClientMetrics(reduceId, jobConf);
        this.copyPhase = copyPhase;
        this.taskStatus = status;
        this.reduceTask = reduceTask;
        this.scheduler = new ShuffleScheduler(jobConf, status, this, copyPhase, shuffledMapsCounter, reduceShuffleBytes, failedShuffleCounter);
        this.merger = new MergeManager<K, V>(reduceId, jobConf, localFS, localDirAllocator, reporter, codec, combinerClass, combineCollector, spilledRecordsCounter, reduceCombineInputCounter, mergedMapOutputsCounter, this, mergePhase, mapOutputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawKeyValueIterator run() throws IOException, InterruptedException {
        EventFetcher<K, V> eventFetcher = new EventFetcher<K, V>(this.reduceId, this.umbilical, this.scheduler, this);
        eventFetcher.start();
        int numFetchers = this.jobConf.getInt("mapreduce.reduce.shuffle.parallelcopies", 5);
        Fetcher[] fetchers = new Fetcher[numFetchers];
        for (int i = 0; i < numFetchers; ++i) {
            fetchers[i] = new Fetcher<K, V>(this.jobConf, this.reduceId, this.scheduler, this.merger, this.reporter, this.metrics, this, this.reduceTask.getJobTokenSecret());
            fetchers[i].start();
        }
        while (!this.scheduler.waitUntilDone(2000)) {
            this.reporter.progress();
            Shuffle i = this;
            synchronized (i) {
                if (this.throwable != null) {
                    throw new ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
                }
            }
        }
        eventFetcher.shutDown();
        for (Fetcher fetcher : fetchers) {
            fetcher.shutDown();
        }
        fetchers = null;
        this.scheduler.close();
        this.copyPhase.complete();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        RawKeyValueIterator kvIter = null;
        try {
            kvIter = this.merger.close();
        }
        catch (Throwable e) {
            throw new ShuffleError("Error while doing final merge ", e);
        }
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (this.throwable != null) {
                throw new ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
            }
        }
        return kvIter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reportException(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
            this.throwingThreadName = Thread.currentThread().getName();
            ShuffleScheduler<K, V> shuffleScheduler = this.scheduler;
            synchronized (shuffleScheduler) {
                this.scheduler.notifyAll();
            }
        }
    }

    public static class ShuffleError
    extends IOException {
        private static final long serialVersionUID = 5753909320586607881L;

        ShuffleError(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

