/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.LineRecordReader;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestLineRecordReader {
    private static Path workDir = new Path(new Path(System.getProperty("test.build.data", "target"), "data"), "TestTextInputFormat");
    private static Path inputDir = new Path(workDir, "input");

    private void testSplitRecords(String testFileName, long firstSplitLength) throws IOException {
        URL testFileUrl = this.getClass().getClassLoader().getResource(testFileName);
        Assert.assertNotNull((String)("Cannot find " + testFileName), (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Configuration conf = new Configuration();
        this.testSplitRecordsForFile(conf, firstSplitLength, testFileSize, testFilePath);
    }

    private void testSplitRecordsForFile(Configuration conf, long firstSplitLength, long testFileSize, Path testFilePath) throws IOException {
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        Assert.assertTrue((String)("unexpected test data at " + testFilePath), (testFileSize > firstSplitLength ? 1 : 0) != 0);
        String delimiter = conf.get("textinputformat.record.delimiter");
        byte[] recordDelimiterBytes = null;
        if (null != delimiter) {
            recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        }
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int numRecordsNoSplits = 0;
        while (reader.next(key, value)) {
            ++numRecordsNoSplits;
        }
        reader.close();
        split = new FileSplit(testFilePath, 0L, firstSplitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        int numRecordsFirstSplit = 0;
        while (reader.next(key, value)) {
            ++numRecordsFirstSplit;
        }
        reader.close();
        split = new FileSplit(testFilePath, firstSplitLength, testFileSize - firstSplitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        int numRecordsRemainingSplits = 0;
        while (reader.next(key, value)) {
            ++numRecordsRemainingSplits;
        }
        reader.close();
        Assert.assertEquals((String)"Unexpected number of records in split", (long)numRecordsNoSplits, (long)(numRecordsFirstSplit + numRecordsRemainingSplits));
    }

    private void testLargeSplitRecordForFile(Configuration conf, long firstSplitLength, long testFileSize, Path testFilePath) throws IOException {
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        Assert.assertTrue((String)("unexpected firstSplitLength:" + firstSplitLength), (testFileSize < firstSplitLength ? 1 : 0) != 0);
        String delimiter = conf.get("textinputformat.record.delimiter");
        byte[] recordDelimiterBytes = null;
        if (null != delimiter) {
            recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        }
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int numRecordsNoSplits = 0;
        while (reader.next(key, value)) {
            ++numRecordsNoSplits;
        }
        reader.close();
        split = new FileSplit(testFilePath, 0L, firstSplitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        int numRecordsFirstSplit = 0;
        while (reader.next(key, value)) {
            ++numRecordsFirstSplit;
        }
        reader.close();
        Assert.assertEquals((String)"Unexpected number of records in split", (long)numRecordsNoSplits, (long)numRecordsFirstSplit);
    }

    @Test
    public void testBzip2SplitEndsAtCR() throws IOException {
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136498L);
    }

    @Test
    public void testBzip2SplitEndsAtCRThenLF() throws IOException {
        this.testSplitRecords("blockEndingInCRThenLF.txt.bz2", 136498L);
    }

    @Test
    public void testBzip2SplitStartAtBlockMarker() throws IOException {
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136504L);
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136505L);
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136508L);
        this.testSplitRecords("blockEndingInCR.txt.bz2", 136494L);
    }

    @Test(expected=IOException.class)
    public void testSafeguardSplittingUnsplittableFiles() throws IOException {
        this.testSplitRecords("TestSafeguardSplittingUnsplittableFiles.txt.gz", 2L);
    }

    public ArrayList<String> readRecords(URL testFileUrl, int splitSize) throws IOException {
        File testFile = new File(testFileUrl.getFile());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 1);
        ArrayList<String> records = new ArrayList<String>();
        LongWritable key = new LongWritable();
        Text value = new Text();
        for (long offset = 0L; offset < testFileSize; offset += (long)splitSize) {
            FileSplit split = new FileSplit(testFilePath, offset, (long)splitSize, (String[])null);
            LineRecordReader reader = new LineRecordReader(conf, split);
            while (reader.next(key, value)) {
                records.add(value.toString());
            }
        }
        return records;
    }

    public String[] readRecordsDirectly(URL testFileUrl, boolean bzip) throws IOException {
        int count;
        int MAX_DATA_SIZE = 0x100000;
        byte[] data = new byte[MAX_DATA_SIZE];
        FileInputStream fis = new FileInputStream(testFileUrl.getFile());
        if (bzip) {
            BZip2CompressorInputStream bzIn = new BZip2CompressorInputStream((InputStream)fis);
            count = bzIn.read(data);
            bzIn.close();
        } else {
            count = fis.read(data);
        }
        fis.close();
        Assert.assertTrue((String)"Test file data too big for buffer", (count < data.length ? 1 : 0) != 0);
        return new String(data, 0, count, "UTF-8").split("\n");
    }

    public void checkRecordSpanningMultipleSplits(String testFile, int splitSize, boolean bzip) throws IOException {
        URL testFileUrl = this.getClass().getClassLoader().getResource(testFile);
        ArrayList<String> records = this.readRecords(testFileUrl, splitSize);
        String[] actuals = this.readRecordsDirectly(testFileUrl, bzip);
        Assert.assertEquals((String)"Wrong number of records", (long)actuals.length, (long)records.size());
        boolean hasLargeRecord = false;
        for (int i = 0; i < actuals.length; ++i) {
            Assert.assertEquals((Object)actuals[i], (Object)records.get(i));
            if (actuals[i].length() <= 2 * splitSize) continue;
            hasLargeRecord = true;
        }
        Assert.assertTrue((String)"Invalid test data. Doesn't have a large enough record", (boolean)hasLargeRecord);
    }

    @Test
    public void testRecordSpanningMultipleSplits() throws IOException {
        this.checkRecordSpanningMultipleSplits("recordSpanningMultipleSplits.txt", 10, false);
    }

    @Test
    public void testRecordSpanningMultipleSplitsCompressed() throws IOException {
        this.checkRecordSpanningMultipleSplits("recordSpanningMultipleSplits.txt.bz2", 200000, true);
    }

    @Test
    public void testStripBOM() throws IOException {
        String UTF8_BOM = "\ufeff";
        URL testFileUrl = this.getClass().getClassLoader().getResource("testBOM.txt");
        Assert.assertNotNull((String)"Cannot find testBOM.txt", (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        Path testFilePath = new Path(testFile.getAbsolutePath());
        long testFileSize = testFile.length();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int numRecords = 0;
        boolean firstLine = true;
        boolean skipBOM = true;
        while (reader.next(key, value)) {
            if (firstLine) {
                firstLine = false;
                if (value.toString().startsWith(UTF8_BOM)) {
                    skipBOM = false;
                }
            }
            ++numRecords;
        }
        reader.close();
        Assert.assertTrue((String)"BOM is not skipped", (boolean)skipBOM);
    }

    @Test
    public void testMultipleClose() throws IOException {
        URL testFileUrl = this.getClass().getClassLoader().getResource("recordSpanningMultipleSplits.txt.bz2");
        Assert.assertNotNull((String)"Cannot find recordSpanningMultipleSplits.txt.bz2", (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        Path testFilePath = new Path(testFile.getAbsolutePath());
        long testFileSize = testFile.length();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(testFilePath, 0L, testFileSize, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split);
        LongWritable key = new LongWritable();
        Text value = new Text();
        while (reader.next(key, value)) {
        }
        reader.close();
        reader.close();
        BZip2Codec codec = new BZip2Codec();
        codec.setConf(conf);
        HashSet<Decompressor> decompressors = new HashSet<Decompressor>();
        for (int i = 0; i < 10; ++i) {
            decompressors.add(CodecPool.getDecompressor((CompressionCodec)codec));
        }
        Assert.assertEquals((long)10L, (long)decompressors.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path createInputFile(Configuration conf, String data) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path file = new Path(inputDir, "test.txt");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));){
            writer.write(data);
        }
        return file;
    }

    @Test
    public void testUncompressedInputWithLargeSplitSize() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "abcde +fghij+ klmno+pqrst+uvwxyz";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        long longSplitSize = 0x80000000L;
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            conf.setInt("io.file.buffer.size", bufferSize);
            this.testLargeSplitRecordForFile(conf, longSplitSize, inputData.length(), inputFile);
        }
    }

    @Test
    public void testUncompressedInput() throws Exception {
        int splitSize;
        int bufferSize;
        Configuration conf = new Configuration();
        String inputData = "abc+def+ghi+jkl+mno+pqr+stu+vw +xyz";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc|+|def|+|ghi|+|jkl|+|mno|+|pqr|+|stu|+|vw |+|xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "|+|");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc+def++ghi+jkl++mno+pqr++stu+vw ++xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc|+||+|defghi|+|jkl|+||+|mno|+|pqr|+||+|stu|+|vw |+||+|xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "|+|");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc+def+-ghi+jkl+-mno+pqr+-stu+vw +-xyz";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+-");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc\n+def\n+ghi\n+jkl\n+mno";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "\n+");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
        inputData = "abc\ndef+\nghi+\njkl\nmno";
        inputFile = this.createInputFile(conf, inputData);
        conf.set("textinputformat.record.delimiter", "+\n");
        for (bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
    }

    @Test
    public void testUncompressedInputContainingCRLF() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "a\r\nb\rc\nd\r\n";
        Path inputFile = this.createInputFile(conf, inputData);
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (int splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                this.testSplitRecordsForFile(conf, splitSize, inputData.length(), inputFile);
            }
        }
    }

    @Test
    public void testUncompressedInputCustomDelimiterPosValue() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("io.file.buffer.size", 10);
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        String inputData = "abcdefghij++kl++mno";
        Path inputFile = this.createInputFile(conf, inputData);
        String delimiter = "++";
        byte[] recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        int splitLength = 15;
        FileSplit split = new FileSplit(inputFile, 0L, (long)splitLength, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        LongWritable key = new LongWritable();
        Text value = new Text();
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong length for record value", (long)10L, (long)value.getLength());
        Assert.assertEquals((String)"Wrong position after record read", (long)12L, (long)reader.getPos());
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong length for record value", (long)2L, (long)value.getLength());
        Assert.assertEquals((String)"Wrong position after record read", (long)16L, (long)reader.getPos());
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong length for record value", (long)3L, (long)value.getLength());
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        Assert.assertFalse((boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        reader.close();
        split = new FileSplit(inputFile, (long)splitLength, (long)(inputData.length() - splitLength), (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        Assert.assertFalse((String)"Unexpected record returned", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        reader.close();
        inputData = "abcd+efgh++ijk++mno";
        inputFile = this.createInputFile(conf, inputData);
        splitLength = 5;
        split = new FileSplit(inputFile, 0L, (long)splitLength, (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)11L, (long)reader.getPos());
        Assert.assertEquals((String)"Wrong length for record value", (long)9L, (long)value.getLength());
        Assert.assertFalse((String)"Unexpected record returned", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)11L, (long)reader.getPos());
        reader.close();
        split = new FileSplit(inputFile, (long)splitLength, (long)(inputData.length() - splitLength), (String[])null);
        reader = new LineRecordReader(conf, split, recordDelimiterBytes);
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)16L, (long)reader.getPos());
        Assert.assertEquals((String)"Wrong length for record value", (long)3L, (long)value.getLength());
        Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        Assert.assertEquals((String)"Wrong length for record value", (long)3L, (long)value.getLength());
        Assert.assertFalse((boolean)reader.next(key, value));
        Assert.assertEquals((String)"Wrong position after record read", (long)19L, (long)reader.getPos());
        reader.close();
        inputData = "abcd|efgh|+|ij|kl|+|mno|pqr";
        inputFile = this.createInputFile(conf, inputData);
        delimiter = "|+|";
        recordDelimiterBytes = delimiter.getBytes(StandardCharsets.UTF_8);
        for (int bufferSize = 1; bufferSize <= inputData.length(); ++bufferSize) {
            for (int splitSize = 1; splitSize < inputData.length(); ++splitSize) {
                conf.setInt("io.file.buffer.size", bufferSize);
                split = new FileSplit(inputFile, 0L, (long)bufferSize, (String[])null);
                reader = new LineRecordReader(conf, split, recordDelimiterBytes);
                Assert.assertTrue((String)"Expected record got nothing", (boolean)reader.next(key, value));
                Assertions.assertThat((String)value.toString()).isEqualTo((Object)"abcd|efgh");
                Assert.assertEquals((String)"Wrong position after record read", (long)9L, (long)value.getLength());
                int recordPos = 12;
                Assert.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                if (reader.next(key, value)) {
                    Assertions.assertThat((String)value.toString()).isEqualTo((Object)"ij|kl");
                    recordPos = 20;
                    Assert.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                }
                if (reader.next(key, value)) {
                    Assertions.assertThat((String)value.toString()).isEqualTo((Object)"mno|pqr");
                    recordPos = inputData.length();
                    Assert.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                }
                Assert.assertFalse((String)"Unexpected record returned", (boolean)reader.next(key, value));
                Assert.assertEquals((String)"Wrong position after record read", (long)recordPos, (long)reader.getPos());
                reader.close();
            }
        }
    }

    @Test
    public void testUncompressedInputDefaultDelimiterPosValue() throws Exception {
        Configuration conf = new Configuration();
        String inputData = "1234567890\r\n12\r\n345";
        Path inputFile = this.createInputFile(conf, inputData);
        conf.setInt("io.file.buffer.size", 10);
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        FileSplit split = new FileSplit(inputFile, 0L, 15L, (String[])null);
        LineRecordReader reader = new LineRecordReader(conf, split, null);
        LongWritable key = new LongWritable();
        Text value = new Text();
        reader.next(key, value);
        Assert.assertEquals((long)10L, (long)value.getLength());
        Assert.assertEquals((long)12L, (long)reader.getPos());
        reader.next(key, value);
        Assert.assertEquals((long)2L, (long)value.getLength());
        Assert.assertEquals((long)16L, (long)reader.getPos());
        Assert.assertFalse((boolean)reader.next(key, value));
        split = new FileSplit(inputFile, 15L, 4L, (String[])null);
        reader = new LineRecordReader(conf, split, null);
        Assert.assertEquals((long)16L, (long)reader.getPos());
        reader.next(key, value);
        Assert.assertEquals((long)3L, (long)value.getLength());
        Assert.assertEquals((long)19L, (long)reader.getPos());
        Assert.assertFalse((boolean)reader.next(key, value));
        Assert.assertEquals((long)19L, (long)reader.getPos());
        inputData = "123456789\r\r\n";
        inputFile = this.createInputFile(conf, inputData);
        split = new FileSplit(inputFile, 0L, 12L, (String[])null);
        reader = new LineRecordReader(conf, split, null);
        reader.next(key, value);
        Assert.assertEquals((long)9L, (long)value.getLength());
        Assert.assertEquals((long)10L, (long)reader.getPos());
        reader.next(key, value);
        Assert.assertEquals((long)0L, (long)value.getLength());
        Assert.assertEquals((long)12L, (long)reader.getPos());
        Assert.assertFalse((boolean)reader.next(key, value));
        Assert.assertEquals((long)12L, (long)reader.getPos());
    }

    @Test
    public void testBzipWithMultibyteDelimiter() throws IOException {
        String testFileName = "compressedMultibyteDelimiter.txt.bz2";
        int firstSplitLength = 100;
        URL testFileUrl = this.getClass().getClassLoader().getResource(testFileName);
        Assert.assertNotNull((String)("Cannot find " + testFileName), (Object)testFileUrl);
        File testFile = new File(testFileUrl.getFile());
        long testFileSize = testFile.length();
        Path testFilePath = new Path(testFile.getAbsolutePath());
        Assert.assertTrue((String)"Split size is smaller than header length", (firstSplitLength > 9 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Split size is larger than compressed file size " + testFilePath), (testFileSize > (long)firstSplitLength ? 1 : 0) != 0);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.input.linerecordreader.line.maxlength", Integer.MAX_VALUE);
        String delimiter = "<E-LINE>\r\r\n";
        conf.set("textinputformat.record.delimiter", delimiter);
        this.testSplitRecordsForFile(conf, firstSplitLength, testFileSize, testFilePath);
    }
}

