/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.LocatedFileStatusFetcher;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocatedFileStatusFetcher
extends AbstractHadoopTestBase {
    private Configuration conf;
    private FileSystem fileSys;
    private boolean mkdirs;
    private File dir = GenericTestUtils.getTestDir((String)"test-lfs-fetcher");
    private static final CountDownLatch LATCH = new CountDownLatch(1);

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration(false);
        this.conf.set("fs.file.impl", MockFileSystem.class.getName());
        this.fileSys = FileSystem.getLocal((Configuration)this.conf);
    }

    @After
    public void after() {
        if (this.mkdirs) {
            FileUtil.fullyDelete((File)this.dir);
        }
    }

    @Test
    public void testExecutorsShutDown() throws Exception {
        Path scanPath = new Path(this.dir.getAbsolutePath());
        this.mkdirs = this.fileSys.mkdirs(scanPath);
        Path[] dirs = new Path[]{scanPath};
        final LocatedFileStatusFetcher fetcher = new LocatedFileStatusFetcher(this.conf, dirs, true, new PathFilter(){

            public boolean accept(Path path) {
                return true;
            }
        }, true);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    fetcher.getFileStatuses();
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)(e instanceof InterruptedException));
                }
            }
        };
        t.start();
        LATCH.await();
        t.interrupt();
        t.join();
        Assert.assertTrue((String)"The executor service should have been shut down", (boolean)fetcher.getListeningExecutorService().isShutdown());
    }

    static class MockFileSystem
    extends LocalFileSystem {
        MockFileSystem() {
        }

        public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
            LATCH.countDown();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return super.globStatus(pathPattern, filter);
        }
    }
}

