/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progress;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestMapTask {
    private static File TEST_ROOT_DIR = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir", "/tmp")), TestMapTask.class.getName());

    @After
    public void cleanup() throws Exception {
        FileUtil.fullyDelete((File)TEST_ROOT_DIR);
    }

    @Test
    public void testShufflePermissions() throws Exception {
        JobConf conf = new JobConf();
        conf.set("fs.permissions.umask-mode", "077");
        conf.set("mapreduce.cluster.local.dir", TEST_ROOT_DIR.getAbsolutePath());
        MROutputFiles mof = new MROutputFiles();
        mof.setConf((Configuration)conf);
        TaskAttemptID attemptId = new TaskAttemptID("12345", 1, TaskType.MAP, 1, 1);
        MapTask mockTask = (MapTask)Mockito.mock(MapTask.class);
        ((MapTask)Mockito.doReturn((Object)mof).when((Object)mockTask)).getMapOutputFile();
        ((MapTask)Mockito.doReturn((Object)attemptId).when((Object)mockTask)).getTaskID();
        ((MapTask)Mockito.doReturn((Object)new Progress()).when((Object)mockTask)).getSortPhase();
        Task.TaskReporter mockReporter = (Task.TaskReporter)Mockito.mock(Task.TaskReporter.class);
        ((Task.TaskReporter)Mockito.doReturn((Object)new Counters.Counter()).when((Object)mockReporter)).getCounter((Enum)ArgumentMatchers.any(TaskCounter.class));
        MapOutputCollector.Context ctx = new MapOutputCollector.Context(mockTask, conf, mockReporter);
        MapTask.MapOutputBuffer mob = new MapTask.MapOutputBuffer();
        mob.init(ctx);
        mob.flush();
        mob.close();
        Path outputFile = mof.getOutputFile();
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        FsPermission perms = lfs.getFileStatus(outputFile).getPermission();
        Assert.assertEquals((String)"Incorrect output file perms", (long)416L, (long)perms.toShort());
        Path indexFile = mof.getOutputIndexFile();
        perms = lfs.getFileStatus(indexFile).getPermission();
        Assert.assertEquals((String)"Incorrect index file perms", (long)416L, (long)perms.toShort());
    }
}

