/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.AMFeedback;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.ExitUtil;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestTask {
    @Mock
    private TaskUmbilicalProtocol umbilical;
    @Mock
    private AMFeedback feedback;
    private Task task;

    @Before
    public void setup() {
        this.task = new StubTask();
        ExitUtil.disableSystemExit();
    }

    @Test
    public void testStatusUpdateDoesNotExitInUberMode() throws Exception {
        this.setupTest(true);
        this.task.statusUpdate(this.umbilical);
    }

    @Test(expected=ExitUtil.ExitException.class)
    public void testStatusUpdateExitsInNonUberMode() throws Exception {
        this.setupTest(false);
        this.task.statusUpdate(this.umbilical);
    }

    private void setupTest(boolean uberized) throws IOException, InterruptedException {
        Configuration conf = new Configuration(false);
        conf.setBoolean("mapreduce.task.uberized", uberized);
        this.task.setConf(conf);
        Mockito.when((Object)this.umbilical.statusUpdate((TaskAttemptID)ArgumentMatchers.any(TaskAttemptID.class), (TaskStatus)ArgumentMatchers.any(TaskStatus.class))).thenReturn((Object)this.feedback);
        Mockito.when((Object)this.feedback.getTaskFound()).thenReturn((Object)false, (Object[])new Boolean[]{true});
    }

    public class StubTask
    extends Task {
        public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException, ClassNotFoundException, InterruptedException {
        }

        public boolean isMapTask() {
            return false;
        }
    }
}

