/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.mapred.AMFeedback;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.checkpoint.TaskCheckpointID;
import org.apache.hadoop.util.ExitUtil;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskProgressReporter {
    private static int statusUpdateTimes = 0;
    volatile boolean threadExited = false;
    static final int LOCAL_BYTES_WRITTEN = 1024;
    private FakeUmbilical fakeUmbilical = new FakeUmbilical();
    private static final String TEST_DIR = System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")) + "/" + TestTaskProgressReporter.class.getName();

    @After
    public void cleanup() {
        FileSystem.clearStatistics();
    }

    @Test(timeout=60000L)
    public void testScratchDirSize() throws Exception {
        String tmpPath = TEST_DIR + "/testBytesWrittenLimit-tmpFile-" + new Random(System.currentTimeMillis()).nextInt();
        File data = new File(tmpPath + "/out");
        File testDir = new File(tmpPath);
        testDir.mkdirs();
        testDir.deleteOnExit();
        JobConf conf = new JobConf();
        conf.setStrings("mapreduce.cluster.local.dir", new String[]{"file://" + tmpPath});
        conf.setLong("mapreduce.job.local-fs.single-disk-limit.bytes", 1024L);
        conf.setBoolean("mapreduce.job.local-fs.single-disk-limit.check.kill-limit-exceed", true);
        this.getBaseConfAndWriteToFile(-1, data);
        this.testScratchDirLimit(false, conf);
        data.delete();
        this.getBaseConfAndWriteToFile(100, data);
        this.testScratchDirLimit(false, conf);
        data.delete();
        this.getBaseConfAndWriteToFile(1536, data);
        this.testScratchDirLimit(true, conf);
        conf.setBoolean("mapreduce.job.local-fs.single-disk-limit.check.kill-limit-exceed", false);
        this.testScratchDirLimit(false, conf);
        conf.setBoolean("mapreduce.job.local-fs.single-disk-limit.check.kill-limit-exceed", true);
        conf.setLong("mapreduce.job.local-fs.single-disk-limit.bytes", -1L);
        this.testScratchDirLimit(false, conf);
        data.delete();
        FileUtil.fullyDelete((File)testDir);
    }

    private void getBaseConfAndWriteToFile(int size, File data) throws IOException {
        if (size > 0) {
            byte[] b = new byte[size];
            for (int i = 0; i < size; ++i) {
                b[i] = 1;
            }
            FileUtils.writeByteArrayToFile((File)data, (byte[])b);
        }
    }

    public void testScratchDirLimit(boolean fastFail, JobConf conf) throws Exception {
        ExitUtil.disableSystemExit();
        this.threadExited = false;
        Thread.UncaughtExceptionHandler h = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                if (ex instanceof ExitUtil.ExitException) {
                    TestTaskProgressReporter.this.threadExited = true;
                    th.interrupt();
                }
            }
        };
        DummyTask task = new DummyTask();
        task.setConf((Configuration)conf);
        DummyTaskReporter reporter = new DummyTaskReporter(task);
        reporter.startDiskLimitCheckerThreadIfNeeded();
        Thread t = new Thread((Runnable)((Object)reporter));
        t.setUncaughtExceptionHandler(h);
        reporter.setProgressFlag();
        t.start();
        while (!reporter.taskLimitIsChecked) {
            Thread.yield();
        }
        task.done(this.fakeUmbilical, reporter);
        reporter.resetDoneFlag();
        t.join(1000L);
        Assert.assertEquals((Object)fastFail, (Object)this.threadExited);
    }

    @Test(timeout=10000L)
    public void testTaskProgress() throws Exception {
        JobConf job = new JobConf();
        job.setLong("mapreduce.task.progress-report.interval", 1000L);
        DummyTask task = new DummyTask();
        task.setConf((Configuration)job);
        DummyTaskReporter reporter = new DummyTaskReporter(task);
        Thread t = new Thread((Runnable)((Object)reporter));
        t.start();
        Thread.sleep(2100L);
        task.setTaskDone();
        reporter.resetDoneFlag();
        t.join();
        Assertions.assertThat((int)statusUpdateTimes).isEqualTo(2);
    }

    @Test(timeout=10000L)
    public void testBytesWrittenRespectingLimit() throws Exception {
        this.testBytesWrittenLimit(2048L, false);
    }

    @Test(timeout=10000L)
    public void testBytesWrittenExceedingLimit() throws Exception {
        this.testBytesWrittenLimit(1023L, true);
    }

    public void testBytesWrittenLimit(long limit, boolean failFast) throws Exception {
        ExitUtil.disableSystemExit();
        this.threadExited = false;
        Thread.UncaughtExceptionHandler h = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread th, Throwable ex) {
                System.out.println("Uncaught exception: " + ex);
                if (ex instanceof ExitUtil.ExitException) {
                    TestTaskProgressReporter.this.threadExited = true;
                }
            }
        };
        JobConf conf = new JobConf();
        conf.getLong("mapreduce.task.progress-report.interval", 0L);
        conf.setLong("mapreduce.task.local-fs.write-limit.bytes", limit);
        LocalFileSystem localFS = FileSystem.getLocal((Configuration)conf);
        Path tmpPath = new Path(TEST_DIR + "/testBytesWrittenLimit-tmpFile-" + new Random(System.currentTimeMillis()).nextInt());
        FSDataOutputStream out = localFS.create(tmpPath, true);
        out.write(new byte[1024]);
        out.close();
        DummyTask task = new DummyTask();
        task.setConf((Configuration)conf);
        DummyTaskReporter reporter = new DummyTaskReporter(task);
        Thread t = new Thread((Runnable)((Object)reporter));
        t.setUncaughtExceptionHandler(h);
        reporter.setProgressFlag();
        t.start();
        while (!reporter.taskLimitIsChecked) {
            Thread.yield();
        }
        task.setTaskDone();
        reporter.resetDoneFlag();
        t.join();
        Assert.assertEquals((Object)failFast, (Object)this.threadExited);
    }

    private class DummyTaskReporter
    extends Task.TaskReporter {
        volatile boolean taskLimitIsChecked;

        public DummyTaskReporter(Task task) {
            Task task2 = task;
            task2.getClass();
            super(task2, task.getProgress(), (TaskUmbilicalProtocol)TestTaskProgressReporter.this.fakeUmbilical);
            this.taskLimitIsChecked = false;
        }

        public void setProgress(float progress) {
            super.setProgress(progress);
        }

        protected void checkTaskLimits() throws Task.TaskReporter.TaskLimitException {
            this.taskLimitIsChecked = true;
            super.checkTaskLimits();
        }
    }

    private static class FakeUmbilical
    implements TaskUmbilicalProtocol {
        private FakeUmbilical() {
        }

        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return null;
        }

        public JvmTask getTask(JvmContext context) throws IOException {
            return null;
        }

        public AMFeedback statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            statusUpdateTimes++;
            AMFeedback feedback = new AMFeedback();
            feedback.setTaskFound(true);
            feedback.setPreemption(true);
            return feedback;
        }

        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) throws IOException {
        }

        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
        }

        public void done(TaskAttemptID taskid) throws IOException {
        }

        public void commitPending(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
        }

        public boolean canCommit(TaskAttemptID taskid) throws IOException {
            return false;
        }

        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
        }

        public void fsError(TaskAttemptID taskId, String message) throws IOException {
        }

        public void fatalError(TaskAttemptID taskId, String message, boolean fastFail) throws IOException {
        }

        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromIndex, int maxLocs, TaskAttemptID id) throws IOException {
            return null;
        }

        public void preempted(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
        }

        public TaskCheckpointID getCheckpointID(TaskID taskID) {
            return null;
        }

        public void setCheckpointID(TaskID tid, TaskCheckpointID cid) {
        }
    }

    private static class DummyTask
    extends Task {
        private DummyTask() {
        }

        public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException, ClassNotFoundException, InterruptedException {
        }

        public boolean isMapTask() {
            return true;
        }

        public boolean isCommitRequired() {
            return false;
        }
    }
}

