/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobPriority;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJob {
    @Test
    public void testJobToString() throws IOException, InterruptedException {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        ClientProtocol client = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)cluster.getClient()).thenReturn((Object)client);
        JobID jobid = new JobID("1014873536921", 6);
        JobStatus status = new JobStatus(jobid, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.FAILED, JobPriority.DEFAULT, "root", "TestJobToString", "job file", "tracking url");
        Mockito.when((Object)client.getJobStatus(jobid)).thenReturn((Object)status);
        Mockito.when((Object)client.getTaskReports(jobid, TaskType.MAP)).thenReturn((Object)new TaskReport[0]);
        Mockito.when((Object)client.getTaskReports(jobid, TaskType.REDUCE)).thenReturn((Object)new TaskReport[0]);
        Mockito.when((Object)client.getTaskCompletionEvents(jobid, 0, 10)).thenReturn((Object)TaskCompletionEvent.EMPTY_ARRAY);
        Job job = Job.getInstance((Cluster)cluster, (JobStatus)status, (Configuration)new JobConf());
        Assert.assertNotNull((Object)job.toString());
    }

    @Test
    public void testUnexpectedJobStatus() throws Exception {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        JobID jobid = new JobID("1014873536921", 6);
        ClientProtocol clientProtocol = (ClientProtocol)Mockito.mock(ClientProtocol.class);
        Mockito.when((Object)cluster.getClient()).thenReturn((Object)clientProtocol);
        JobStatus status = new JobStatus(jobid, 0.0f, 0.0f, 0.0f, 0.0f, JobStatus.State.RUNNING, JobPriority.DEFAULT, "root", "testUnexpectedJobStatus", "job file", "tracking URL");
        Mockito.when((Object)clientProtocol.getJobStatus(jobid)).thenReturn((Object)status);
        Job job = Job.getInstance((Cluster)cluster, (JobStatus)status, (Configuration)new JobConf());
        Assert.assertNotNull((Object)job.getStatus());
        Assert.assertTrue((job.getStatus().getState() == JobStatus.State.RUNNING ? 1 : 0) != 0);
        Mockito.when((Object)clientProtocol.getJobStatus(jobid)).thenReturn(null);
        try {
            job.updateStatus();
        }
        catch (IOException e) {
            Assert.assertTrue((e != null && e.getMessage().contains("Job status not available") ? 1 : 0) != 0);
        }
        try {
            ControlledJob cj = new ControlledJob(job, null);
            Assert.assertNotNull((Object)cj.toString());
        }
        catch (NullPointerException e) {
            Assert.fail((String)"job API fails with NPE");
        }
    }

    @Test
    public void testUGICredentialsPropogation() throws Exception {
        Credentials creds = new Credentials();
        Token token = (Token)Mockito.mock(Token.class);
        Text tokenService = new Text("service");
        Text secretName = new Text("secret");
        byte[] secret = new byte[]{};
        creds.addToken(tokenService, token);
        creds.addSecretKey(secretName, secret);
        UserGroupInformation.getLoginUser().addCredentials(creds);
        JobConf jobConf = new JobConf();
        Job job = new Job(jobConf);
        Assert.assertSame((Object)token, (Object)job.getCredentials().getToken(tokenService));
        Assert.assertSame((Object)secret, (Object)job.getCredentials().getSecretKey(secretName));
    }
}

