/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.NotRunningJob;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.FailTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillJobRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.KillTaskAttemptRequest;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class ClientServiceDelegate {
    private static final Log LOG = LogFactory.getLog(ClientServiceDelegate.class);
    private static final String UNAVAILABLE = "N/A";
    private HashMap<JobState, HashMap<String, NotRunningJob>> notRunningJobs;
    private final Configuration conf;
    private final JobID jobId;
    private final ApplicationId appId;
    private final ResourceMgrDelegate rm;
    private final MRClientProtocol historyServerProxy;
    private MRClientProtocol realProxy = null;
    private RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static String UNKNOWN_USER = "Unknown User";
    private String trackingUrl;
    private boolean amAclDisabledStatusLogged = false;

    public ClientServiceDelegate(Configuration conf, ResourceMgrDelegate rm, JobID jobId, MRClientProtocol historyServerProxy) {
        this.conf = new Configuration(conf);
        this.conf.setInt("ipc.client.connect.max.retries", this.conf.getInt("yarn.app.mapreduce.client-am.ipc.max-retries", 3));
        this.rm = rm;
        this.jobId = jobId;
        this.historyServerProxy = historyServerProxy;
        this.appId = TypeConverter.toYarn((JobID)jobId).getAppId();
        this.notRunningJobs = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotRunningJob getNotRunningJob(ApplicationReport applicationReport, JobState state) {
        HashMap<JobState, HashMap<String, NotRunningJob>> hashMap = this.notRunningJobs;
        synchronized (hashMap) {
            String user;
            NotRunningJob notRunningJob;
            HashMap<String, NotRunningJob> map = this.notRunningJobs.get(state);
            if (map == null) {
                map = new HashMap();
                this.notRunningJobs.put(state, map);
            }
            if ((notRunningJob = map.get(user = applicationReport == null ? UNKNOWN_USER : applicationReport.getUser())) == null) {
                notRunningJob = new NotRunningJob(applicationReport, state);
                map.put(user, notRunningJob);
            }
            return notRunningJob;
        }
    }

    private MRClientProtocol getProxy() throws YarnRemoteException {
        if (this.realProxy != null) {
            return this.realProxy;
        }
        ApplicationReport application = this.rm.getApplicationReport(this.appId);
        if (application != null) {
            this.trackingUrl = application.getTrackingUrl();
        }
        InetSocketAddress serviceAddr = null;
        while (application == null || YarnApplicationState.RUNNING == application.getYarnApplicationState()) {
            if (application == null) {
                LOG.info((Object)("Could not get Job info from RM for job " + this.jobId + ". Redirecting to job history server."));
                return this.checkAndGetHSProxy(null, JobState.NEW);
            }
            try {
                UserGroupInformation newUgi;
                if (application.getHost() == null || "".equals(application.getHost())) {
                    LOG.debug((Object)"AM not assigned to Job. Waiting to get the AM ...");
                    Thread.sleep(2000L);
                    LOG.debug((Object)("Application state is " + application.getYarnApplicationState()));
                    application = this.rm.getApplicationReport(this.appId);
                    continue;
                }
                if (UNAVAILABLE.equals(application.getHost())) {
                    if (!this.amAclDisabledStatusLogged) {
                        LOG.info((Object)("Job " + this.jobId + " is running, but the host is unknown." + " Verify user has VIEW_JOB access."));
                        this.amAclDisabledStatusLogged = true;
                    }
                    return this.getNotRunningJob(application, JobState.RUNNING);
                }
                if (!this.conf.getBoolean("mapreduce.job.am-access-disabled", false)) {
                    newUgi = UserGroupInformation.createRemoteUser((String)UserGroupInformation.getCurrentUser().getUserName());
                    serviceAddr = NetUtils.createSocketAddrForHost((String)application.getHost(), (int)application.getRpcPort());
                    if (UserGroupInformation.isSecurityEnabled()) {
                        String clientTokenEncoded = application.getClientToken();
                        Token clientToken = new Token();
                        clientToken.decodeFromUrlString(clientTokenEncoded);
                        SecurityUtil.setTokenService((Token)clientToken, (InetSocketAddress)serviceAddr);
                        newUgi.addToken(clientToken);
                    }
                } else {
                    if (!this.amAclDisabledStatusLogged) {
                        LOG.info((Object)("Network ACL closed to AM for job " + this.jobId + ". Not going to try to reach the AM."));
                        this.amAclDisabledStatusLogged = true;
                    }
                    return this.getNotRunningJob(null, JobState.RUNNING);
                }
                LOG.debug((Object)("Connecting to " + serviceAddr));
                final InetSocketAddress finalServiceAddr = serviceAddr;
                this.realProxy = (MRClientProtocol)newUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MRClientProtocol>(){

                    @Override
                    public MRClientProtocol run() throws IOException {
                        return ClientServiceDelegate.this.instantiateAMProxy(finalServiceAddr);
                    }
                });
                return this.realProxy;
            }
            catch (IOException e) {
                LOG.info((Object)("Could not connect to " + serviceAddr + ". Waiting for getting the latest AM address..."));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    LOG.warn((Object)"getProxy() call interruped", (Throwable)e1);
                    throw new YarnException((Throwable)e1);
                }
                application = this.rm.getApplicationReport(this.appId);
                if (application != null) continue;
                LOG.info((Object)("Could not get Job info from RM for job " + this.jobId + ". Redirecting to job history server."));
                return this.checkAndGetHSProxy(null, JobState.RUNNING);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"getProxy() call interruped", (Throwable)e);
                throw new YarnException((Throwable)e);
            }
        }
        String user = application.getUser();
        if (user == null) {
            throw RPCUtil.getRemoteException((String)"User is not set in the application report");
        }
        if (application.getYarnApplicationState() == YarnApplicationState.NEW || application.getYarnApplicationState() == YarnApplicationState.SUBMITTED) {
            this.realProxy = null;
            return this.getNotRunningJob(application, JobState.NEW);
        }
        if (application.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.realProxy = null;
            return this.getNotRunningJob(application, JobState.FAILED);
        }
        if (application.getYarnApplicationState() == YarnApplicationState.KILLED) {
            this.realProxy = null;
            return this.getNotRunningJob(application, JobState.KILLED);
        }
        if (application.getYarnApplicationState() == YarnApplicationState.FINISHED) {
            LOG.info((Object)("Application state is completed. FinalApplicationStatus=" + application.getFinalApplicationStatus().toString() + ". Redirecting to job history server"));
            this.realProxy = this.checkAndGetHSProxy(application, JobState.SUCCEEDED);
        }
        return this.realProxy;
    }

    private MRClientProtocol checkAndGetHSProxy(ApplicationReport applicationReport, JobState state) {
        if (null == this.historyServerProxy) {
            LOG.warn((Object)"Job History Server is not configured.");
            return this.getNotRunningJob(applicationReport, state);
        }
        return this.historyServerProxy;
    }

    MRClientProtocol instantiateAMProxy(InetSocketAddress serviceAddr) throws IOException {
        LOG.trace((Object)("Connecting to ApplicationMaster at: " + serviceAddr));
        YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        MRClientProtocol proxy = (MRClientProtocol)rpc.getProxy(MRClientProtocol.class, serviceAddr, this.conf);
        LOG.trace((Object)("Connected to ApplicationMaster at: " + serviceAddr));
        return proxy;
    }

    private synchronized Object invoke(String method, Class argClass, Object args) throws IOException {
        Method methodOb = null;
        try {
            methodOb = MRClientProtocol.class.getMethod(method, argClass);
        }
        catch (SecurityException e) {
            throw new YarnException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnException("Method name mismatch", (Throwable)e);
        }
        int maxRetries = this.conf.getInt("yarn.app.mapreduce.client.max-retries", 3);
        IOException lastException = null;
        while (maxRetries > 0) {
            try {
                return methodOb.invoke((Object)this.getProxy(), args);
            }
            catch (YarnRemoteException yre) {
                LOG.warn((Object)"Exception thrown by remote end.", (Throwable)yre);
                throw yre;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof YarnRemoteException) {
                    LOG.warn((Object)("Error from remote end: " + e.getTargetException().getLocalizedMessage()));
                    LOG.debug((Object)"Tracing remote error ", e.getTargetException());
                    throw (YarnRemoteException)e.getTargetException();
                }
                LOG.debug((Object)("Failed to contact AM/History for job " + this.jobId + " retrying.."), e.getTargetException());
                this.realProxy = null;
                --maxRetries;
                lastException = new IOException(e.getMessage());
            }
            catch (Exception e) {
                LOG.debug((Object)("Failed to contact AM/History for job " + this.jobId + "  Will retry.."), (Throwable)e);
                this.realProxy = null;
                --maxRetries;
                lastException = new IOException(e.getMessage());
            }
        }
        throw lastException;
    }

    public Counters getJobCounters(JobID arg0) throws IOException, InterruptedException {
        JobId jobID = TypeConverter.toYarn((JobID)arg0);
        GetCountersRequest request = (GetCountersRequest)this.recordFactory.newRecordInstance(GetCountersRequest.class);
        request.setJobId(jobID);
        org.apache.hadoop.mapreduce.v2.api.records.Counters cnt = ((GetCountersResponse)this.invoke("getCounters", GetCountersRequest.class, request)).getCounters();
        return TypeConverter.fromYarn((org.apache.hadoop.mapreduce.v2.api.records.Counters)cnt);
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(JobID arg0, int arg1, int arg2) throws IOException, InterruptedException {
        JobId jobID = TypeConverter.toYarn((JobID)arg0);
        GetTaskAttemptCompletionEventsRequest request = (GetTaskAttemptCompletionEventsRequest)this.recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsRequest.class);
        request.setJobId(jobID);
        request.setFromEventId(arg1);
        request.setMaxEvents(arg2);
        List list = ((GetTaskAttemptCompletionEventsResponse)this.invoke("getTaskAttemptCompletionEvents", GetTaskAttemptCompletionEventsRequest.class, request)).getCompletionEventList();
        return TypeConverter.fromYarn((TaskAttemptCompletionEvent[])list.toArray(new TaskAttemptCompletionEvent[0]));
    }

    public String[] getTaskDiagnostics(TaskAttemptID arg0) throws IOException, InterruptedException {
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)arg0);
        GetDiagnosticsRequest request = (GetDiagnosticsRequest)this.recordFactory.newRecordInstance(GetDiagnosticsRequest.class);
        request.setTaskAttemptId(attemptID);
        List list = ((GetDiagnosticsResponse)this.invoke("getDiagnostics", GetDiagnosticsRequest.class, request)).getDiagnosticsList();
        String[] result = new String[list.size()];
        int i = 0;
        for (String c : list) {
            result[i++] = c.toString();
        }
        return result;
    }

    public JobStatus getJobStatus(JobID oldJobID) throws IOException {
        String historyTrackingUrl;
        String url;
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        GetJobReportRequest request = (GetJobReportRequest)this.recordFactory.newRecordInstance(GetJobReportRequest.class);
        request.setJobId(jobId);
        JobReport report = ((GetJobReportResponse)this.invoke("getJobReport", GetJobReportRequest.class, request)).getJobReport();
        if (StringUtils.isEmpty((String)report.getJobFile())) {
            String jobFile = MRApps.getJobFile((Configuration)this.conf, (String)report.getUser(), (JobID)oldJobID);
            report.setJobFile(jobFile);
        }
        String string = url = StringUtils.isNotEmpty((String)(historyTrackingUrl = report.getTrackingUrl())) ? historyTrackingUrl : this.trackingUrl;
        if (!UNAVAILABLE.equals(url)) {
            url = "http://" + url;
        }
        return TypeConverter.fromYarn((JobReport)report, (String)url);
    }

    public TaskReport[] getTaskReports(JobID oldJobID, TaskType taskType) throws IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        GetTaskReportsRequest request = (GetTaskReportsRequest)this.recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        request.setJobId(jobId);
        request.setTaskType(TypeConverter.toYarn((TaskType)taskType));
        List taskReports = ((GetTaskReportsResponse)this.invoke("getTaskReports", GetTaskReportsRequest.class, request)).getTaskReportList();
        return TypeConverter.fromYarn((List)taskReports).toArray(new TaskReport[0]);
    }

    public boolean killTask(TaskAttemptID taskAttemptID, boolean fail) throws IOException {
        TaskAttemptId attemptID = TypeConverter.toYarn((TaskAttemptID)taskAttemptID);
        if (fail) {
            FailTaskAttemptRequest failRequest = (FailTaskAttemptRequest)this.recordFactory.newRecordInstance(FailTaskAttemptRequest.class);
            failRequest.setTaskAttemptId(attemptID);
            this.invoke("failTaskAttempt", FailTaskAttemptRequest.class, failRequest);
        } else {
            KillTaskAttemptRequest killRequest = (KillTaskAttemptRequest)this.recordFactory.newRecordInstance(KillTaskAttemptRequest.class);
            killRequest.setTaskAttemptId(attemptID);
            this.invoke("killTaskAttempt", KillTaskAttemptRequest.class, killRequest);
        }
        return true;
    }

    public boolean killJob(JobID oldJobID) throws IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        KillJobRequest killRequest = (KillJobRequest)this.recordFactory.newRecordInstance(KillJobRequest.class);
        killRequest.setJobId(jobId);
        this.invoke("killJob", KillJobRequest.class, killRequest);
        return true;
    }

    public LogParams getLogFilePath(JobID oldJobID, TaskAttemptID oldTaskAttemptID) throws YarnRemoteException, IOException {
        JobId jobId = TypeConverter.toYarn((JobID)oldJobID);
        GetJobReportRequest request = (GetJobReportRequest)this.recordFactory.newRecordInstance(GetJobReportRequest.class);
        request.setJobId(jobId);
        JobReport report = ((GetJobReportResponse)this.invoke("getJobReport", GetJobReportRequest.class, request)).getJobReport();
        if (EnumSet.of(JobState.SUCCEEDED, JobState.FAILED, JobState.KILLED, JobState.ERROR).contains(report.getJobState())) {
            if (oldTaskAttemptID != null) {
                GetTaskAttemptReportRequest taRequest = (GetTaskAttemptReportRequest)this.recordFactory.newRecordInstance(GetTaskAttemptReportRequest.class);
                taRequest.setTaskAttemptId(TypeConverter.toYarn((TaskAttemptID)oldTaskAttemptID));
                TaskAttemptReport taReport = ((GetTaskAttemptReportResponse)this.invoke("getTaskAttemptReport", GetTaskAttemptReportRequest.class, taRequest)).getTaskAttemptReport();
                if (taReport.getContainerId() == null || taReport.getNodeManagerHost() == null) {
                    throw new IOException("Unable to get log information for task: " + oldTaskAttemptID);
                }
                return new LogParams(taReport.getContainerId().toString(), taReport.getContainerId().getApplicationAttemptId().getApplicationId().toString(), BuilderUtils.newNodeId((String)taReport.getNodeManagerHost(), (int)taReport.getNodeManagerPort()).toString(), report.getUser());
            }
            if (report.getAMInfos() == null || report.getAMInfos().size() == 0) {
                throw new IOException("Unable to get log information for job: " + oldJobID);
            }
            AMInfo amInfo = (AMInfo)report.getAMInfos().get(report.getAMInfos().size() - 1);
            return new LogParams(amInfo.getContainerId().toString(), amInfo.getAppAttemptId().getApplicationId().toString(), BuilderUtils.newNodeId((String)amInfo.getNodeManagerHost(), (int)amInfo.getNodeManagerPort()).toString(), report.getUser());
        }
        throw new IOException("Cannot get log path for a in-progress job");
    }
}

