/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import com.google.common.base.Charsets;
import java.io.DataInput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.nativetask.util.ConfigUtil;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
public class NativeRuntime {
    private static Log LOG = LogFactory.getLog(NativeRuntime.class);
    private static boolean nativeLibraryLoaded = false;
    private static Configuration conf = new Configuration();

    private static void assertNativeLibraryLoaded() {
        if (!nativeLibraryLoaded) {
            throw new RuntimeException("Native runtime library not loaded");
        }
    }

    public static boolean isNativeLibraryLoaded() {
        return nativeLibraryLoaded;
    }

    public static void configure(Configuration jobConf) {
        NativeRuntime.assertNativeLibraryLoaded();
        conf = new Configuration(jobConf);
        conf.set("native.hadoop.version", VersionInfo.getVersion());
        NativeRuntime.JNIConfigure(ConfigUtil.toBytes(conf));
    }

    public static synchronized long createNativeObject(String clazz) {
        NativeRuntime.assertNativeLibraryLoaded();
        long ret = NativeRuntime.JNICreateNativeObject(clazz.getBytes(Charsets.UTF_8));
        if (ret == 0L) {
            LOG.warn((Object)("Can't create NativeObject for class " + clazz + ", probably not exist."));
        }
        return ret;
    }

    public static synchronized long registerLibrary(String libraryName, String clazz) {
        NativeRuntime.assertNativeLibraryLoaded();
        long ret = NativeRuntime.JNIRegisterModule(libraryName.getBytes(Charsets.UTF_8), clazz.getBytes(Charsets.UTF_8));
        if (ret != 0L) {
            LOG.warn((Object)("Can't create NativeObject for class " + clazz + ", probably not exist."));
        }
        return ret;
    }

    public static synchronized void releaseNativeObject(long addr) {
        NativeRuntime.assertNativeLibraryLoaded();
        NativeRuntime.JNIReleaseNativeObject(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportStatus(Task.TaskReporter reporter) throws IOException {
        NativeRuntime.assertNativeLibraryLoaded();
        Task.TaskReporter taskReporter = reporter;
        synchronized (taskReporter) {
            byte[] statusBytes = NativeRuntime.JNIUpdateStatus();
            DataInputBuffer ib = new DataInputBuffer();
            ib.reset(statusBytes, statusBytes.length);
            FloatWritable progress = new FloatWritable();
            progress.readFields((DataInput)ib);
            reporter.setProgress(progress.get());
            Text status = new Text();
            status.readFields((DataInput)ib);
            if (status.getLength() > 0) {
                reporter.setStatus(status.toString());
            }
            IntWritable numCounters = new IntWritable();
            numCounters.readFields((DataInput)ib);
            if (numCounters.get() == 0) {
                return;
            }
            Text group = new Text();
            Text name = new Text();
            LongWritable amount = new LongWritable();
            for (int i = 0; i < numCounters.get(); ++i) {
                group.readFields((DataInput)ib);
                name.readFields((DataInput)ib);
                amount.readFields((DataInput)ib);
                reporter.incrCounter(group.toString(), name.toString(), amount.get());
            }
        }
    }

    public static native boolean supportsCompressionCodec(byte[] var0);

    private static native void JNIConfigure(byte[][] var0);

    private static native long JNICreateNativeObject(byte[] var0);

    @Deprecated
    private static native long JNICreateDefaultNativeObject(byte[] var0);

    private static native void JNIReleaseNativeObject(long var0);

    private static native byte[] JNIUpdateStatus();

    private static native void JNIRelease();

    private static native int JNIRegisterModule(byte[] var0, byte[] var1);

    static {
        try {
            System.loadLibrary("nativetask");
            LOG.info((Object)"Nativetask JNI library loaded.");
            nativeLibraryLoaded = true;
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed to load nativetask JNI library with error: " + t));
            LOG.info((Object)("java.library.path=" + System.getProperty("java.library.path")));
            LOG.info((Object)("LD_LIBRARY_PATH=" + System.getenv("LD_LIBRARY_PATH")));
        }
    }
}

