/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask;

import java.io.IOException;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.nativetask.Platform;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;
import org.apache.hadoop.mapred.nativetask.serde.NativeSerialization;

@InterfaceAudience.Private
public class Platforms {
    private static final Log LOG = LogFactory.getLog(Platforms.class);
    private static final ServiceLoader<Platform> platforms = ServiceLoader.load(Platform.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Configuration conf) throws IOException {
        NativeSerialization.getInstance().reset();
        ServiceLoader<Platform> serviceLoader = platforms;
        synchronized (serviceLoader) {
            for (Platform platform : platforms) {
                platform.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean support(String keyClassName, INativeSerializer<?> serializer, JobConf job) {
        ServiceLoader<Platform> serviceLoader = platforms;
        synchronized (serviceLoader) {
            for (Platform platform : platforms) {
                if (!platform.support(keyClassName, serializer, job)) continue;
                LOG.debug((Object)("platform " + platform.name() + " support key class" + keyClassName));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean define(Class<?> keyComparator) {
        ServiceLoader<Platform> serviceLoader = platforms;
        synchronized (serviceLoader) {
            for (Platform platform : platforms) {
                if (!platform.define(keyComparator)) continue;
                LOG.debug((Object)("platform " + platform.name() + " define comparator " + keyComparator.getName()));
                return true;
            }
        }
        return false;
    }
}

