/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.nativetask.buffer.BufferType;
import org.apache.hadoop.mapred.nativetask.buffer.ByteBufferDataReader;
import org.apache.hadoop.mapred.nativetask.buffer.InputBuffer;
import org.apache.hadoop.mapred.nativetask.serde.KVSerializer;
import org.apache.hadoop.mapred.nativetask.util.SizedWritable;

@InterfaceAudience.Private
public class BufferPushee<OK, OV>
implements Closeable {
    private static Log LOG = LogFactory.getLog(BufferPushee.class);
    public static final int KV_HEADER_LENGTH = 8;
    private InputBuffer asideBuffer;
    private final SizedWritable<OK> tmpOutputKey;
    private final SizedWritable<OV> tmpOutputValue;
    private RecordWriter<OK, OV> writer;
    private ByteBufferDataReader nativeReader;
    private KVSerializer<OK, OV> deserializer;
    private boolean closed = false;

    public BufferPushee(Class<OK> oKClass, Class<OV> oVClass, RecordWriter<OK, OV> writer) throws IOException {
        this.tmpOutputKey = new SizedWritable(oKClass);
        this.tmpOutputValue = new SizedWritable(oVClass);
        this.writer = writer;
        if (null != oKClass && null != oVClass) {
            this.deserializer = new KVSerializer<OK, OV>(oKClass, oVClass);
        }
        this.nativeReader = new ByteBufferDataReader(null);
    }

    public boolean collect(InputBuffer buffer) throws IOException {
        if (this.closed) {
            return false;
        }
        ByteBuffer input = buffer.getByteBuffer();
        if (null != this.asideBuffer && this.asideBuffer.length() > 0) {
            if (this.asideBuffer.remaining() > 0) {
                byte[] output = this.asideBuffer.getByteBuffer().array();
                int write = Math.min(this.asideBuffer.remaining(), input.remaining());
                input.get(output, this.asideBuffer.position(), write);
                this.asideBuffer.position(this.asideBuffer.position() + write);
            }
            if (this.asideBuffer.remaining() == 0 && this.asideBuffer.position() > 0) {
                this.asideBuffer.position(0);
                this.write(this.asideBuffer);
                this.asideBuffer.rewind(0, 0);
            }
        }
        if (input.remaining() == 0) {
            return true;
        }
        if (input.remaining() < 8) {
            throw new IOException("incomplete data, input length is: " + input.remaining());
        }
        int position = input.position();
        int keyLength = input.getInt();
        int valueLength = input.getInt();
        input.position(position);
        int kvLength = keyLength + valueLength + 8;
        int remaining = input.remaining();
        if (kvLength > remaining) {
            if (null == this.asideBuffer || this.asideBuffer.capacity() < kvLength) {
                this.asideBuffer = new InputBuffer(BufferType.HEAP_BUFFER, kvLength);
            }
            this.asideBuffer.rewind(0, kvLength);
            input.get(this.asideBuffer.array(), 0, remaining);
            this.asideBuffer.position(remaining);
        } else {
            this.write(buffer);
        }
        return true;
    }

    private boolean write(InputBuffer input) throws IOException {
        if (this.closed) {
            return false;
        }
        int totalRead = 0;
        int remain = input.remaining();
        this.nativeReader.reset(input);
        while (remain > totalRead) {
            int read = this.deserializer.deserializeKV(this.nativeReader, this.tmpOutputKey, this.tmpOutputValue);
            if (read == 0) continue;
            totalRead += read;
            this.writer.write((Object)this.tmpOutputKey.v, (Object)this.tmpOutputValue.v);
        }
        if (remain != totalRead) {
            throw new IOException("We expect to read " + remain + ", but we actually read: " + totalRead);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (null != this.writer) {
            this.writer.close(null);
        }
        if (null != this.nativeReader) {
            this.nativeReader.close();
        }
        this.closed = true;
    }
}

