/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.serde;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.nativetask.buffer.DataInputStream;
import org.apache.hadoop.mapred.nativetask.buffer.DataOutputStream;
import org.apache.hadoop.mapred.nativetask.serde.IKVSerializer;
import org.apache.hadoop.mapred.nativetask.serde.INativeSerializer;
import org.apache.hadoop.mapred.nativetask.serde.NativeSerialization;
import org.apache.hadoop.mapred.nativetask.util.SizedWritable;

@InterfaceAudience.Private
public class KVSerializer<K, V>
implements IKVSerializer {
    private static final Log LOG = LogFactory.getLog(KVSerializer.class);
    public static final int KV_HEAD_LENGTH = 8;
    private final INativeSerializer<Writable> keySerializer;
    private final INativeSerializer<Writable> valueSerializer;

    public KVSerializer(Class<K> kclass, Class<V> vclass) throws IOException {
        this.keySerializer = NativeSerialization.getInstance().getSerializer(kclass);
        this.valueSerializer = NativeSerialization.getInstance().getSerializer(vclass);
    }

    @Override
    public void updateLength(SizedWritable<?> key, SizedWritable<?> value) throws IOException {
        key.length = this.keySerializer.getLength(key.v);
        value.length = this.valueSerializer.getLength(value.v);
    }

    @Override
    public int serializeKV(DataOutputStream out, SizedWritable<?> key, SizedWritable<?> value) throws IOException {
        return this.serializePartitionKV(out, -1, key, value);
    }

    @Override
    public int serializePartitionKV(DataOutputStream out, int partitionId, SizedWritable<?> key, SizedWritable<?> value) throws IOException {
        if (key.length == -1 || value.length == -1) {
            this.updateLength(key, value);
        }
        int keyLength = key.length;
        int valueLength = value.length;
        int bytesWritten = 8 + keyLength + valueLength;
        if (partitionId != -1) {
            bytesWritten += 4;
        }
        if (out.hasUnFlushedData() && out.shortOfSpace(bytesWritten)) {
            out.flush();
        }
        if (partitionId != -1) {
            out.writeInt(partitionId);
        }
        out.writeInt(keyLength);
        out.writeInt(valueLength);
        this.keySerializer.serialize(key.v, out);
        this.valueSerializer.serialize(value.v, out);
        return bytesWritten;
    }

    @Override
    public int deserializeKV(DataInputStream in, SizedWritable<?> key, SizedWritable<?> value) throws IOException {
        if (!in.hasUnReadData()) {
            return 0;
        }
        key.length = in.readInt();
        value.length = in.readInt();
        this.keySerializer.deserialize(in, key.length, key.v);
        this.valueSerializer.deserialize(in, value.length, value.v);
        return key.length + value.length + 8;
    }
}

