/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mount;

import java.io.IOException;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.SimpleUdpServer;
import org.apache.hadoop.util.ShutdownHookManager;

public abstract class MountdBase {
    private final RpcProgram rpcProgram;
    private int udpBoundPort;
    private int tcpBoundPort;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    public MountdBase(RpcProgram program) throws IOException {
        this.rpcProgram = program;
    }

    private void startUDPServer() {
        SimpleUdpServer udpServer = new SimpleUdpServer(this.rpcProgram.getPort(), this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        udpServer.run();
        this.udpBoundPort = udpServer.getBoundPort();
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(this.rpcProgram.getPort(), this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        tcpServer.run();
        this.tcpBoundPort = tcpServer.getBoundPort();
    }

    public void start(boolean register) {
        this.startUDPServer();
        this.startTCPServer();
        if (register) {
            ShutdownHookManager.get().addShutdownHook((Runnable)new Unregister(), 10);
            this.rpcProgram.register(17, this.udpBoundPort);
            this.rpcProgram.register(6, this.tcpBoundPort);
        }
    }

    private class Unregister
    implements Runnable {
        private Unregister() {
        }

        @Override
        public synchronized void run() {
            MountdBase.this.rpcProgram.unregister(17, MountdBase.this.udpBoundPort);
            MountdBase.this.rpcProgram.unregister(6, MountdBase.this.tcpBoundPort);
        }
    }
}

