/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.oncrpc.XDR;

public class CREATE3Request
extends RequestWithHandle {
    private final String name;
    private final int mode;
    private SetAttr3 objAttr = null;
    private long verf;

    public CREATE3Request(FileHandle handle, String name, int mode, SetAttr3 objAttr, long verf) {
        super(handle);
        this.name = name;
        this.mode = mode;
        this.objAttr = objAttr;
        this.verf = verf;
    }

    public CREATE3Request(XDR xdr) throws IOException {
        super(xdr);
        this.name = xdr.readString();
        this.mode = xdr.readInt();
        this.objAttr = new SetAttr3();
        if (this.mode == 0 || this.mode == 1) {
            this.objAttr.deserialize(xdr);
        } else if (this.mode == 2) {
            this.verf = xdr.readHyper();
        } else {
            throw new IOException("Wrong create mode:" + this.mode);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMode() {
        return this.mode;
    }

    public SetAttr3 getObjAttr() {
        return this.objAttr;
    }

    public long getVerf() {
        return this.verf;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeInt(this.name.length());
        xdr.writeFixedOpaque(this.name.getBytes(), this.name.length());
        xdr.writeInt(this.mode);
        this.objAttr.serialize(xdr);
    }
}

