/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public final class RpcUtil {
    private static int xid = (int)(System.currentTimeMillis() / 1000L) << 12;
    public static final SimpleChannelUpstreamHandler STAGE_RPC_MESSAGE_PARSER = new RpcMessageParserStage();
    public static final SimpleChannelUpstreamHandler STAGE_RPC_TCP_RESPONSE = new RpcTcpResponseStage();
    public static final SimpleChannelUpstreamHandler STAGE_RPC_UDP_RESPONSE = new RpcUdpResponseStage();

    public static int getNewXid(String caller) {
        ++xid;
        return xid += caller.hashCode();
    }

    public static void sendRpcResponse(ChannelHandlerContext ctx, RpcResponse response) {
        Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)response);
    }

    public static FrameDecoder constructRpcFrameDecoder() {
        return new RpcFrameDecoder();
    }

    private static final class RpcUdpResponseStage
    extends SimpleChannelUpstreamHandler {
        private RpcUdpResponseStage() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            RpcResponse r = (RpcResponse)e.getMessage();
            e.getChannel().write((Object)r.data(), r.remoteAddress());
        }
    }

    private static class RpcTcpResponseStage
    extends SimpleChannelUpstreamHandler {
        private RpcTcpResponseStage() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            RpcResponse r = (RpcResponse)e.getMessage();
            byte[] fragmentHeader = XDR.recordMark(r.data().readableBytes(), true);
            ChannelBuffer header = ChannelBuffers.wrappedBuffer((byte[])fragmentHeader);
            ChannelBuffer d = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{header, r.data()});
            e.getChannel().write((Object)d);
        }
    }

    static final class RpcMessageParserStage
    extends SimpleChannelUpstreamHandler {
        private static final Log LOG = LogFactory.getLog(RpcMessageParserStage.class);

        RpcMessageParserStage() {
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            ChannelBuffer buf = (ChannelBuffer)e.getMessage();
            ByteBuffer b = buf.toByteBuffer().asReadOnlyBuffer();
            XDR in = new XDR(b, XDR.State.READING);
            RpcInfo info = null;
            try {
                RpcCall callHeader = RpcCall.read(in);
                ChannelBuffer dataBuffer = ChannelBuffers.wrappedBuffer((ByteBuffer)in.buffer().slice());
                info = new RpcInfo(callHeader, dataBuffer, ctx, e.getChannel(), e.getRemoteAddress());
            }
            catch (Exception exc) {
                LOG.info((Object)("Malfromed RPC request from " + e.getRemoteAddress()));
            }
            if (info != null) {
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, info);
            }
        }
    }

    static class RpcFrameDecoder
    extends FrameDecoder {
        public static final Log LOG = LogFactory.getLog(RpcFrameDecoder.class);
        private ChannelBuffer currentFrame;

        RpcFrameDecoder() {
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buf) {
            if (buf.readableBytes() < 4) {
                return null;
            }
            buf.markReaderIndex();
            byte[] fragmentHeader = new byte[4];
            buf.readBytes(fragmentHeader);
            int length = XDR.fragmentSize(fragmentHeader);
            boolean isLast = XDR.isLastFragment(fragmentHeader);
            if (buf.readableBytes() < length) {
                buf.resetReaderIndex();
                return null;
            }
            ChannelBuffer newFragment = buf.readSlice(length);
            this.currentFrame = this.currentFrame == null ? newFragment : ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{this.currentFrame, newFragment});
            if (isLast) {
                ChannelBuffer completeFrame = this.currentFrame;
                this.currentFrame = null;
                return completeFrame;
            }
            return null;
        }
    }
}

