/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIRPLUS3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class READDIRPLUS3Response
extends NFS3Response {
    private Nfs3FileAttributes postOpDirAttr;
    private final long cookieVerf;
    private final DirListPlus3 dirListPlus;

    @VisibleForTesting
    public DirListPlus3 getDirListPlus() {
        return this.dirListPlus;
    }

    public READDIRPLUS3Response(int status) {
        this(status, null, 0L, null);
    }

    public READDIRPLUS3Response(int status, Nfs3FileAttributes postOpDirAttr, long cookieVerf, DirListPlus3 dirListPlus) {
        super(status);
        this.postOpDirAttr = postOpDirAttr;
        this.cookieVerf = cookieVerf;
        this.dirListPlus = dirListPlus;
    }

    public XDR writeHeaderAndResponse(XDR out, int xid, Verifier verifier) {
        super.writeHeaderAndResponse(out, xid, verifier);
        out.writeBoolean(true);
        if (this.postOpDirAttr == null) {
            this.postOpDirAttr = new Nfs3FileAttributes();
        }
        this.postOpDirAttr.serialize(out);
        if (this.getStatus() == 0) {
            out.writeLongAsHyper(this.cookieVerf);
            for (EntryPlus3 f : this.dirListPlus.getEntries()) {
                out.writeBoolean(true);
                f.seralize(out);
            }
            out.writeBoolean(false);
            out.writeBoolean(this.dirListPlus.getEof());
        }
        return out;
    }
}

