/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class SimpleTcpServer {
    public static final Log LOG = LogFactory.getLog(SimpleTcpServer.class);
    protected final int port;
    protected int boundPort = -1;
    protected final SimpleChannelUpstreamHandler rpcProgram;
    protected final int workerCount;

    public SimpleTcpServer(int port, RpcProgram program, int workercount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workercount;
    }

    public void run() {
        NioServerSocketChannelFactory factory = this.workerCount == 0 ? new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()) : new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), this.workerCount);
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new /* Unavailable Anonymous Inner Class!! */);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        InetSocketAddress socketAddr = (InetSocketAddress)ch.getLocalAddress();
        this.boundPort = socketAddr.getPort();
        LOG.info((Object)("Started listening to TCP requests at port " + this.boundPort + " for " + this.rpcProgram + " with workerCount " + this.workerCount));
    }

    public int getBoundPort() {
        return this.boundPort;
    }
}

