/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.cli.ReplicationManagerCommands;
import org.apache.hadoop.hdds.scm.cli.SafeModeCommands;
import org.apache.hadoop.hdds.scm.cli.TopologySubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ContainerCommands;
import org.apache.hadoop.hdds.scm.cli.container.WithScmClient;
import org.apache.hadoop.hdds.scm.cli.datanode.DatanodeCommands;
import org.apache.hadoop.hdds.scm.cli.pipeline.PipelineCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import picocli.CommandLine;

@CommandLine.Command(name="ozone admin", hidden=true, description={"Developer tools for Ozone Admin operations"}, versionProvider=HddsVersionProvider.class, subcommands={OMAdmin.class, SafeModeCommands.class, ContainerCommands.class, PipelineCommands.class, DatanodeCommands.class, TopologySubcommand.class, ReplicationManagerCommands.class}, mixinStandardHelpOptions=true)
public class OzoneAdmin
extends GenericCli
implements WithScmClient {
    private OzoneConfiguration ozoneConf;
    @CommandLine.Option(names={"--scm"}, description={"The destination scm (host:port)"})
    private String scm = "";

    public OzoneConfiguration getOzoneConf() {
        if (this.ozoneConf == null) {
            this.ozoneConf = this.createOzoneConfiguration();
        }
        return this.ozoneConf;
    }

    public static void main(String[] argv) throws Exception {
        LogManager.resetConfiguration();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        Logger.getLogger(NativeCodeLoader.class).setLevel(Level.ERROR);
        new OzoneAdmin().run(argv);
    }

    public ScmClient createScmClient() {
        try {
            OzoneConfiguration conf = this.createOzoneConfiguration();
            this.checkAndSetSCMAddressArg((MutableConfigurationSource)conf);
            return new ContainerOperationClient(conf);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Can't create SCM client", ex);
        }
    }

    private void checkAndSetSCMAddressArg(MutableConfigurationSource conf) {
        if (StringUtils.isNotEmpty((CharSequence)this.scm)) {
            conf.set("ozone.scm.client.address", this.scm);
        }
        if (!HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.client.address"}).isPresent()) {
            throw new IllegalArgumentException("ozone.scm.client.address should be set in ozone-site.xml or with the --scm option");
        }
    }
}

