/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.debug.ChunkDataNodeDetails;
import org.apache.hadoop.ozone.debug.ChunkDetails;
import org.apache.hadoop.ozone.debug.ContainerChunkInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.protocol.ClientId;
import picocli.CommandLine;

@CommandLine.Command(name="chunkinfo", description={"returns chunk location information about an existing key"})
public class ChunkKeyHandler
extends KeyHandler {
    @CommandLine.Parameters(arity="1..1", description={"key to be located"})
    private String uri;
    private ContainerOperationClient containerOperationClient;
    private XceiverClientManager xceiverClientManager;
    private XceiverClientSpi xceiverClient;
    private final ClientId clientId = ClientId.randomId();
    private OzoneManagerProtocol ozoneManagerClient;

    private String getChunkLocationPath(String containerLocation) {
        return containerLocation + File.separator + "chunks";
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        this.containerOperationClient = new ContainerOperationClient(this.createOzoneConfiguration());
        this.xceiverClientManager = this.containerOperationClient.getXceiverClientManager();
        this.ozoneManagerClient = client.getObjectStore().getClientProxy().getOzoneManagerClient();
        address.ensureKeyAddress();
        JsonObject jsonObj = new JsonObject();
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        String keyName = address.getKeyName();
        List tempchunks = null;
        ArrayList<ChunkDetails> chunkDetailsList = new ArrayList<ChunkDetails>();
        ArrayList<String> chunkPaths = new ArrayList<String>();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).setRefreshPipeline(true).build();
        OmKeyInfo keyInfo = this.ozoneManagerClient.lookupKey(keyArgs);
        List locationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
        ChunkLayOutVersion chunkLayOutVersion = ChunkLayOutVersion.getConfiguredVersion((ConfigurationSource)this.getConf());
        for (OmKeyLocationInfo keyLocation : locationInfos) {
            JsonElement element;
            Object chunkInfo2;
            ContainerChunkInfo containerChunkInfoVerbose = new ContainerChunkInfo();
            ContainerChunkInfo containerChunkInfo = new ContainerChunkInfo();
            long containerId = keyLocation.getContainerID();
            Token token = keyLocation.getToken();
            this.xceiverClient = this.xceiverClientManager.acquireClient(keyLocation.getPipeline());
            if (token != null) {
                UserGroupInformation.getCurrentUser().addToken(token);
            }
            ContainerProtos.DatanodeBlockID datanodeBlockID = keyLocation.getBlockID().getDatanodeBlockIDProtobuf();
            ContainerProtos.GetBlockResponseProto response = ContainerProtocolCalls.getBlock((XceiverClientSpi)this.xceiverClient, (ContainerProtos.DatanodeBlockID)datanodeBlockID);
            tempchunks = response.getBlockData().getChunksList();
            ContainerProtos.ContainerDataProto containerData = this.containerOperationClient.readContainer(keyLocation.getContainerID(), keyLocation.getPipeline());
            for (Object chunkInfo2 : tempchunks) {
                ChunkDetails chunkDetails = new ChunkDetails();
                chunkDetails.setChunkName(chunkInfo2.getChunkName());
                chunkDetails.setChunkOffset(chunkInfo2.getOffset());
                chunkDetailsList.add(chunkDetails);
                chunkPaths.add(chunkLayOutVersion.getChunkFile(new File(this.getChunkLocationPath(containerData.getContainerPath())), keyLocation.getBlockID(), ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunkInfo2)).toString());
            }
            containerChunkInfoVerbose.setContainerPath(containerData.getContainerPath());
            containerChunkInfoVerbose.setDataNodeList(keyLocation.getPipeline().getNodes());
            containerChunkInfoVerbose.setPipeline(keyLocation.getPipeline());
            containerChunkInfoVerbose.setChunkInfos(chunkDetailsList);
            containerChunkInfo.setFiles(chunkPaths);
            ArrayList<ChunkDataNodeDetails> chunkDataNodeDetails = new ArrayList<ChunkDataNodeDetails>();
            chunkInfo2 = keyLocation.getPipeline().getNodes().iterator();
            while (chunkInfo2.hasNext()) {
                DatanodeDetails datanodeDetails = (DatanodeDetails)chunkInfo2.next();
                chunkDataNodeDetails.add(new ChunkDataNodeDetails(datanodeDetails.getIpAddress(), datanodeDetails.getHostName()));
            }
            containerChunkInfo.setChunkDataNodeDetails(chunkDataNodeDetails);
            containerChunkInfo.setPipelineID(keyLocation.getPipeline().getId().getId());
            Gson gson = new GsonBuilder().create();
            if (this.isVerbose()) {
                element = gson.toJsonTree((Object)containerChunkInfoVerbose);
                jsonObj.add("container Id :" + containerId + " blockId :" + keyLocation.getLocalID() + "", element);
                continue;
            }
            element = gson.toJsonTree((Object)containerChunkInfo);
            jsonObj.add("container Id :" + containerId + " blockId :" + keyLocation.getLocalID() + "", element);
        }
        this.xceiverClientManager.releaseClient(this.xceiverClient, false);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String prettyJson = gson.toJson((JsonElement)jsonObj);
        System.out.println(prettyJson);
    }
}

