/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.ozone.debug.DBDefinitionFactory;
import org.apache.hadoop.ozone.debug.RDBParser;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import picocli.CommandLine;

@CommandLine.Command(name="scan", description={"Parse specified metadataTable"})
public class DBScanner
implements Callable<Void> {
    @CommandLine.Option(names={"--column_family"}, description={"Table name"})
    private String tableName;
    @CommandLine.ParentCommand
    private RDBParser parent;
    private HashMap<String, DBColumnFamilyDefinition> columnFamilyMap;

    private static void displayTable(RocksDB rocksDB, DBColumnFamilyDefinition dbColumnFamilyDefinition, List<ColumnFamilyHandle> list) throws IOException {
        ColumnFamilyHandle columnFamilyHandle = DBScanner.getColumnFamilyHandle(dbColumnFamilyDefinition.getTableName().getBytes(StandardCharsets.UTF_8), list);
        if (columnFamilyHandle == null) {
            throw new IllegalArgumentException("columnFamilyHandle is null");
        }
        RocksIterator iterator = rocksDB.newIterator(columnFamilyHandle);
        iterator.seekToFirst();
        while (iterator.isValid()) {
            Object o = dbColumnFamilyDefinition.getValueCodec().fromPersistedFormat(iterator.value());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String result = gson.toJson(o);
            System.out.println(result);
            iterator.next();
        }
    }

    private static ColumnFamilyHandle getColumnFamilyHandle(byte[] name, List<ColumnFamilyHandle> columnFamilyHandles) {
        return columnFamilyHandles.stream().filter(handle -> {
            try {
                return Arrays.equals(handle.getName(), name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).findAny().orElse(null);
    }

    private void constructColumnFamilyMap(DBDefinition dbDefinition) {
        DBColumnFamilyDefinition[] columnFamilyDefinitions;
        if (dbDefinition == null) {
            System.out.println("Incorrect Db Path");
            return;
        }
        this.columnFamilyMap = new HashMap();
        for (DBColumnFamilyDefinition definition : columnFamilyDefinitions = dbDefinition.getColumnFamilies()) {
            this.columnFamilyMap.put(definition.getTableName(), definition);
        }
    }

    @Override
    public Void call() throws Exception {
        ArrayList<ColumnFamilyDescriptor> cfs = new ArrayList<ColumnFamilyDescriptor>();
        ArrayList<ColumnFamilyHandle> columnFamilyHandleList = new ArrayList<ColumnFamilyHandle>();
        List cfList = null;
        cfList = RocksDB.listColumnFamilies((Options)new Options(), (String)this.parent.getDbPath());
        if (cfList != null) {
            for (byte[] b : cfList) {
                cfs.add(new ColumnFamilyDescriptor(b));
            }
        }
        RocksDB rocksDB = null;
        rocksDB = RocksDB.openReadOnly((String)this.parent.getDbPath(), cfs, columnFamilyHandleList);
        this.printAppropriateTable(columnFamilyHandleList, rocksDB, this.parent.getDbPath());
        return null;
    }

    private void printAppropriateTable(List<ColumnFamilyHandle> columnFamilyHandleList, RocksDB rocksDB, String dbPath) throws IOException {
        dbPath = this.removeTrailingSlashIfNeeded(dbPath);
        this.constructColumnFamilyMap(DBDefinitionFactory.getDefinition(new File(dbPath).getName()));
        if (this.columnFamilyMap != null) {
            if (!this.columnFamilyMap.containsKey(this.tableName)) {
                System.out.print("Table with specified name does not exist");
            } else {
                DBColumnFamilyDefinition columnFamilyDefinition = this.columnFamilyMap.get(this.tableName);
                DBScanner.displayTable(rocksDB, columnFamilyDefinition, columnFamilyHandleList);
            }
        } else {
            System.out.println("Incorrect db Path");
        }
    }

    private String removeTrailingSlashIfNeeded(String dbPath) {
        if (dbPath.endsWith("/")) {
            dbPath = dbPath.substring(0, dbPath.length() - 1);
        }
        return dbPath;
    }
}

