/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.freon.Freon;
import org.apache.hadoop.ozone.freon.PathSchema;
import org.apache.hadoop.ozone.freon.ProgressBar;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OmTransportFactory;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class BaseFreonGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFreonGenerator.class);
    private static final int CHECK_INTERVAL_MILLIS = 1000;
    private static final String DIGEST_ALGORITHM = "MD5";
    private static final Pattern ENV_VARIABLE_IN_PATTERN = Pattern.compile("__(.+?)__");
    @CommandLine.ParentCommand
    private Freon freonCommand;
    @CommandLine.Option(names={"-n", "--number-of-tests"}, description={"Number of the generated objects."}, defaultValue="1000")
    private long testNo = 1000L;
    @CommandLine.Option(names={"-t", "--threads", "--thread"}, description={"Number of threads used to execute"}, defaultValue="10")
    private int threadNo;
    @CommandLine.Option(names={"-f", "--fail-at-end"}, description={"If turned on, all the tasks will be executed even if there are failures."})
    private boolean failAtEnd;
    @CommandLine.Option(names={"-p", "--prefix"}, description={"Unique identifier of the test execution. Usually used as a prefix of the generated object names. If empty, a random name will be generated"}, defaultValue="")
    private String prefix = "";
    private MetricRegistry metrics = new MetricRegistry();
    private AtomicLong successCounter;
    private AtomicLong failureCounter;
    private AtomicLong attemptCounter;
    private long startTime;
    private PathSchema pathSchema;
    private String spanName;
    private ExecutorService executor;
    private ProgressBar progressBar;

    public void runTests(TaskProvider provider) {
        this.setup(provider);
        this.startTaskRunners(provider);
        this.waitForCompletion();
        this.shutdown();
        this.reportAnyFailure();
    }

    private void setup(TaskProvider provider) {
        this.spanName = provider.getClass().getSimpleName().split("\\$")[0];
    }

    private void startTaskRunners(TaskProvider provider) {
        for (int i = 0; i < this.threadNo; ++i) {
            this.executor.execute(() -> this.taskLoop(provider));
        }
    }

    private void taskLoop(TaskProvider provider) {
        long counter;
        while ((counter = this.attemptCounter.getAndIncrement()) < this.testNo && (this.failAtEnd || this.failureCounter.get() <= 0L)) {
            this.tryNextTask(provider, counter);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryNextTask(TaskProvider provider, long taskId) {
        Span span = GlobalTracer.get().buildSpan(this.spanName).start();
        try (Scope scope = GlobalTracer.get().activateSpan(span);){
            provider.executeNextTask(taskId);
            this.successCounter.incrementAndGet();
        }
        catch (Exception e) {
            span.setTag("failure", true);
            this.failureCounter.incrementAndGet();
            LOG.error("Error on executing task {}", (Object)taskId, (Object)e);
        }
        finally {
            span.finish();
        }
    }

    private void waitForCompletion() {
        while (this.successCounter.get() + this.failureCounter.get() < this.testNo && (this.failureCounter.get() == 0L || this.failAtEnd)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private void shutdown() {
        if (this.failureCounter.get() > 0L && !this.failAtEnd) {
            this.progressBar.terminate();
        } else {
            this.progressBar.shutdown();
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void reportAnyFailure() {
        if (this.failureCounter.get() > 0L) {
            throw new RuntimeException("One ore more freon test is failed.");
        }
    }

    public void init() {
        this.freonCommand.startHttpServer();
        this.successCounter = new AtomicLong(0L);
        this.failureCounter = new AtomicLong(0L);
        this.attemptCounter = new AtomicLong(0L);
        this.prefix = this.prefix.length() == 0 ? RandomStringUtils.randomAlphanumeric((int)10).toLowerCase() : this.resolvePrefix(this.prefix);
        LOG.info("Executing test with prefix {}", (Object)this.prefix);
        this.pathSchema = new PathSchema(this.prefix);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.freonCommand.stopHttpServer();
            }
            catch (Exception ex) {
                LOG.error("HTTP server can't be stopped.", (Throwable)ex);
            }
            this.printReport();
        }));
        this.executor = Executors.newFixedThreadPool(this.threadNo);
        this.progressBar = new ProgressBar(System.out, this.testNo, this.successCounter::get, this.freonCommand.isInteractive());
        this.progressBar.start();
        this.startTime = System.currentTimeMillis();
    }

    public String resolvePrefix(String inputPrefix) {
        Matcher m = ENV_VARIABLE_IN_PATTERN.matcher(inputPrefix);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String environment = System.getenv(m.group(1));
            m.appendReplacement(sb, environment != null ? environment : "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public void printReport() {
        ConsoleReporter reporter = this.freonCommand.isInteractive() ? ConsoleReporter.forRegistry((MetricRegistry)this.metrics).build() : Slf4jReporter.forRegistry((MetricRegistry)this.metrics).build();
        reporter.report();
        LinkedList<String> messages = new LinkedList<String>();
        messages.add("Total execution time (sec): " + Math.round((double)(System.currentTimeMillis() - this.startTime) / 1000.0));
        messages.add("Failures: " + this.failureCounter.get());
        messages.add("Successful executions: " + this.successCounter.get());
        Consumer<String> print = this.freonCommand.isInteractive() ? System.out::println : arg_0 -> ((Logger)LOG).info(arg_0);
        messages.forEach(print);
    }

    public OzoneManagerProtocolClientSideTranslatorPB createOmClient(OzoneConfiguration conf, String omServiceID) throws IOException {
        String[] configuredServiceIds;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        RPC.setProtocolEngine((Configuration)conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        String clientId = ClientId.randomId().toString();
        if (omServiceID == null && (configuredServiceIds = conf.getTrimmedStrings("ozone.om.service.ids")).length == 1) {
            omServiceID = configuredServiceIds[0];
        }
        OmTransport transport = OmTransportFactory.create((ConfigurationSource)conf, (UserGroupInformation)ugi, (String)omServiceID);
        return new OzoneManagerProtocolClientSideTranslatorPB(transport, clientId);
    }

    public StorageContainerLocationProtocol createStorageContainerLocationClient(OzoneConfiguration ozoneConf) throws IOException {
        long version = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddress = HddsUtils.getScmAddressForClients((ConfigurationSource)ozoneConf);
        RPC.setProtocolEngine((Configuration)ozoneConf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        StorageContainerLocationProtocol client = (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)version, (InetSocketAddress)scmAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)ozoneConf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)ozoneConf), (int)Client.getRpcTimeout((Configuration)ozoneConf))), StorageContainerLocationProtocol.class, (ConfigurationSource)ozoneConf);
        return client;
    }

    public static Pipeline findPipelineForTest(String pipelineId, StorageContainerLocationProtocol client, Logger log) throws IOException {
        Pipeline pipeline;
        List pipelines = client.listPipelines();
        if (pipelineId != null && pipelineId.length() > 0) {
            pipeline = pipelines.stream().filter(p -> p.getId().toString().equals(pipelineId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is defined, but there is no such pipeline: " + pipelineId));
        } else {
            pipeline = pipelines.stream().filter(p -> p.getFactor() == HddsProtos.ReplicationFactor.THREE).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is NOT defined, and no pipeline has been found with factor=THREE"));
            log.info("Using pipeline {}", (Object)pipeline.getId());
        }
        return pipeline;
    }

    public String generateObjectName(long counter) {
        return this.pathSchema.getPath(counter);
    }

    public void ensureVolumeAndBucketExist(OzoneClient rpcClient, String volumeName, String bucketName) throws IOException {
        this.ensureVolumeExists(rpcClient, volumeName);
        OzoneVolume volume = rpcClient.getObjectStore().getVolume(volumeName);
        try {
            volume.getBucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                volume.createBucket(bucketName);
            }
            throw ex;
        }
    }

    public void ensureVolumeExists(OzoneClient rpcClient, String volumeName) throws IOException {
        try {
            rpcClient.getObjectStore().getVolume(volumeName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                rpcClient.getObjectStore().createVolume(volumeName);
            }
            throw ex;
        }
    }

    public static byte[] getDigest(byte[] content) {
        DigestUtils dig = new DigestUtils(DIGEST_ALGORITHM);
        dig.getMessageDigest().reset();
        return dig.digest(content);
    }

    public static byte[] getDigest(InputStream stream) throws IOException {
        DigestUtils dig = new DigestUtils(DIGEST_ALGORITHM);
        dig.getMessageDigest().reset();
        return dig.digest(stream);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    public OzoneConfiguration createOzoneConfiguration() {
        return this.freonCommand.createOzoneConfiguration();
    }

    public AtomicLong getAttemptCounter() {
        return this.attemptCounter;
    }

    public int getThreadNo() {
        return this.threadNo;
    }

    protected OzoneClient createOzoneClient(String omServiceID, OzoneConfiguration conf) throws Exception {
        if (omServiceID != null) {
            return OzoneClientFactory.getRpcClient((String)omServiceID, (ConfigurationSource)conf);
        }
        return OzoneClientFactory.getRpcClient((ConfigurationSource)conf);
    }

    @FunctionalInterface
    public static interface TaskProvider {
        public void executeNextTask(long var1) throws Exception;
    }
}

